# generated by datamodel-codegen:
#   filename:  api/data/createContainer.json
#   timestamp: 2025-07-18T13:46:59+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import container
from ...type import basic, entityReference, entityReferenceList, lifeCycle, tagLabel


class CreateContainerRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this Container model.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this Container model.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Container instance.'),
    ]
    service: Annotated[
        basic.FullyQualifiedEntityName,
        Field(
            description='Link to the storage service where this container is hosted in.'
        ),
    ]
    parent: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Link to the parent container under which this entity sits.',
        ),
    ]
    dataModel: Annotated[
        Optional[container.ContainerDataModel],
        Field(
            None,
            description="References to the container's data model, if data is structured, or null otherwise",
        ),
    ]
    prefix: Annotated[
        Optional[str],
        Field(None, description='Optional prefix path defined for this container'),
    ]
    numberOfObjects: Annotated[
        Optional[float],
        Field(None, description='The number of objects/files this container has.'),
    ]
    size: Annotated[
        Optional[float],
        Field(None, description='The total size in KB this container has.'),
    ]
    fileFormats: Annotated[
        Optional[List[container.FileFormat]],
        Field(
            None,
            description='File & data formats identified for the container:  e.g. dataFormats=[csv, json]. These can be present both when the container has a dataModel or not',
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owner of this database'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Container Model'),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl], Field(None, description='Source URL of container.')
    ]
    fullPath: Annotated[
        Optional[str], Field(None, description='Full path of the container/file.')
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None,
            description='Fully qualified name of the domain the Container belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
