# generated by datamodel-codegen:
#   filename:  api/governance/createWorkflowDefinition.json
#   timestamp: 2025-07-18T13:46:59+00:00

from __future__ import annotations

from typing import List, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...governance.workflows import workflowDefinition
from ...governance.workflows.elements import edge
from ...governance.workflows.elements.nodes.automatedTask import (
    checkEntityAttributesTask,
    setEntityCertificationTask,
    setGlossaryTermStatusTask,
)
from ...governance.workflows.elements.nodes.endEvent import endEvent
from ...governance.workflows.elements.nodes.startEvent import startEvent
from ...governance.workflows.elements.nodes.userTask import userApprovalTask
from ...governance.workflows.elements.triggers import (
    eventBasedEntityTrigger,
    periodicBatchEntityTrigger,
)
from ...type import basic, entityReferenceList


class CreateWorkflowDefinitionRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this Workflow Definition.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None, description='Display Name that identifies this Workflow Definition.'
        ),
    ]
    description: Annotated[
        basic.Markdown,
        Field(
            description='Description of the Workflow Definition. What it has and how to use it.'
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this API Collection'),
    ]
    type: Optional[workflowDefinition.Type] = None
    trigger: Optional[
        Union[
            eventBasedEntityTrigger.EventBasedEntityTriggerDefinition,
            periodicBatchEntityTrigger.PeriodicBatchEntityTriggerDefinition,
        ]
    ] = None
    nodes: Annotated[
        Optional[
            List[
                Union[
                    checkEntityAttributesTask.CheckEntityAttributesTaskDefinition,
                    setGlossaryTermStatusTask.SetGlossaryTermStatusTaskDefinition,
                    setEntityCertificationTask.SetEntityCertificationTaskDefinition,
                    endEvent.EndEventDefinition,
                    startEvent.StartEventDefinition,
                    userApprovalTask.UserApprovalTaskDefinition,
                ]
            ]
        ],
        Field(None, description='List of processes used on the workflow.'),
    ]
    edges: Annotated[
        Optional[List[edge.EdgeDefinition]],
        Field(
            None,
            description='List of edges that connect the workflow elements and guide its flow.',
        ),
    ]
