# generated by datamodel-codegen:
#   filename:  configuration/elasticSearchConfiguration.json
#   timestamp: 2025-07-18T13:46:59+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class SearchType(Enum):
    elasticsearch = 'elasticsearch'
    opensearch = 'opensearch'


class Bedrock(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    region: Annotated[
        Optional[str], Field('us-east-1', description='AWS Region for Bedrock service')
    ]
    modelId: Annotated[
        Optional[str],
        Field(
            'anthropic.claude-v2',
            description='Bedrock model identifier to use for query transformation',
        ),
    ]
    accessKey: Annotated[
        Optional[str],
        Field(None, description='AWS access key for Bedrock service authentication'),
    ]
    secretKey: Annotated[
        Optional[str],
        Field(None, description='AWS secret key for Bedrock service authentication'),
    ]
    useIamRole: Annotated[
        Optional[bool],
        Field(
            False,
            description='Set to true to use IAM role based authentication instead of access/secret keys.',
        ),
    ]


class NaturalLanguageSearch(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enabled: Annotated[
        Optional[bool],
        Field(False, description='Enable or disable natural language search'),
    ]
    providerClass: Annotated[
        Optional[str],
        Field(
            'org.openmetadata.service.search.nlq.NoOpNLQService',
            description='Fully qualified class name of the NLQService implementation to use',
        ),
    ]
    bedrock: Annotated[
        Optional[Bedrock],
        Field(
            None,
            description='AWS Bedrock configuration for natural language processing',
        ),
    ]


class SearchIndexMappingLanguage(Enum):
    EN = 'EN'
    JP = 'JP'
    ZH = 'ZH'


class ElasticSearchConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    host: Annotated[str, Field(description='Elastic Search Host')]
    port: Annotated[int, Field(description='Elastic Search port')]
    scheme: Annotated[str, Field(description='Http/Https connection scheme')]
    username: Annotated[
        Optional[str], Field(None, description='Elastic Search Username for Login')
    ]
    password: Annotated[
        Optional[str], Field(None, description='Elastic Search Password for Login')
    ]
    truststorePath: Annotated[Optional[str], Field(None, description='Truststore Path')]
    truststorePassword: Annotated[
        Optional[str], Field(None, description='Truststore Password')
    ]
    connectionTimeoutSecs: Annotated[
        int, Field(description='Connection Timeout in Seconds')
    ]
    socketTimeoutSecs: Annotated[int, Field(description='Socket Timeout in Seconds')]
    keepAliveTimeoutSecs: Annotated[
        Optional[int], Field(None, description='Keep Alive Timeout in Seconds')
    ]
    batchSize: Annotated[int, Field(description='Batch Size for Requests')]
    payLoadSize: Annotated[
        Optional[int],
        Field(
            10485760,
            description='Payload size in bytes depending on elasticsearch config',
        ),
    ]
    clusterAlias: Annotated[
        Optional[str],
        Field(
            None,
            description='Alias for search indexes to provide segregation of indexes.',
        ),
    ]
    searchIndexMappingLanguage: SearchIndexMappingLanguage
    searchType: Annotated[
        Optional[SearchType],
        Field(
            SearchType.elasticsearch,
            description='This enum defines the search Type elastic/open search.',
        ),
    ]
    searchIndexFactoryClassName: Annotated[
        Optional[str], Field(None, description='Index factory name')
    ]
    naturalLanguageSearch: Annotated[
        Optional[NaturalLanguageSearch],
        Field(
            None, description='Configuration for natural language search capabilities'
        ),
    ]
