# generated by datamodel-codegen:
#   filename:  entity/data/searchIndex.json
#   timestamp: 2025-07-18T13:46:59+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    votes,
)
from ..services import searchService


class SearchIndexSettings(RootModel[Optional[Dict[str, Any]]]):
    root: Optional[Dict[str, Any]] = None


class SearchIndexSampleData(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    messages: Annotated[
        Optional[List[str]],
        Field(None, description='List of local sample messages for a SearchIndex.'),
    ]


class IndexType(Enum):
    Index = 'Index'
    IndexTemplate = 'IndexTemplate'


class DataType(Enum):
    NUMBER = 'NUMBER'
    TEXT = 'TEXT'
    BINARY = 'BINARY'
    TIMESTAMP = 'TIMESTAMP'
    TIMESTAMPZ = 'TIMESTAMPZ'
    TIME = 'TIME'
    DATE = 'DATE'
    DATETIME = 'DATETIME'
    KEYWORD = 'KEYWORD'
    ARRAY = 'ARRAY'
    OBJECT = 'OBJECT'
    FLATTENED = 'FLATTENED'
    NESTED = 'NESTED'
    JOIN = 'JOIN'
    RANGE = 'RANGE'
    IP = 'IP'
    VERSION = 'VERSION'
    MURMUR3 = 'MURMUR3'
    AGGREGATE_METRIC_DOUBLE = 'AGGREGATE_METRIC_DOUBLE'
    HISTOGRAM = 'HISTOGRAM'
    ANNOTATED_TEXT = 'ANNOTATED-TEXT'
    COMPLETION = 'COMPLETION'
    SEARCH_AS_YOU_TYPE = 'SEARCH_AS_YOU_TYPE'
    DENSE_VECTOR = 'DENSE_VECTOR'
    RANK_FEATURE = 'RANK_FEATURE'
    RANK_FEATURES = 'RANK_FEATURES'
    GEO_POINT = 'GEO_POINT'
    GEO_SHAPE = 'GEO_SHAPE'
    POINT = 'POINT'
    SHAPE = 'SHAPE'
    PERCOLATOR = 'PERCOLATOR'
    BOOLEAN = 'BOOLEAN'
    CONSTANT_KEYWORD = 'CONSTANT_KEYWORD'
    WILDCARD = 'WILDCARD'
    LONG = 'LONG'
    INTEGER = 'INTEGER'
    SHORT = 'SHORT'
    BYTE = 'BYTE'
    DOUBLE = 'DOUBLE'
    FLOAT = 'FLOAT'
    HALF_FLOAT = 'HALF_FLOAT'
    SCALED_FLOAT = 'SCALED_FLOAT'
    UNSIGNED_LONG = 'UNSIGNED_LONG'
    UNKNOWN = 'UNKNOWN'


class SearchIndexFieldName(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description='Local name (not fully qualified name) of the field. ',
            max_length=256,
            min_length=1,
            
        ),
    ]


class SearchIndexField(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: SearchIndexFieldName
    displayName: Annotated[
        Optional[str],
        Field(
            None, description='Display Name that identifies this searchIndexField name.'
        ),
    ]
    dataType: Annotated[
        DataType, Field(description='Data type of the searchIndex (int, date etc.).')
    ]
    dataTypeDisplay: Annotated[
        Optional[str], Field(None, description='Display name used for dataType. ')
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of the field.')
    ]
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = None
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags associated with the column.'),
    ]
    children: Annotated[
        Optional[List[SearchIndexField]],
        Field(None, description='Child columns if dataType has properties.'),
    ]


class SearchIndex(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(
            description='Unique identifier that identifies this SearchIndex instance.'
        ),
    ]
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies the SearchIndex.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description="Name that uniquely identifies a SearchIndex in the format 'searchServiceName.searchIndexName'.",
        ),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this SearchIndex. It could be title or label from the source services.',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the SearchIndex instance.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    service: Annotated[
        entityReference.EntityReference,
        Field(
            description='Link to the search cluster/service where this SearchIndex is hosted in.'
        ),
    ]
    serviceType: Annotated[
        Optional[searchService.SearchServiceType],
        Field(None, description='Service type where this SearchIndex is hosted in.'),
    ]
    fields: Annotated[
        List[SearchIndexField], Field(description='Fields in this SearchIndex.')
    ]
    searchIndexSettings: Annotated[
        Optional[SearchIndexSettings],
        Field(None, description='Contains key/value pair of searchIndex settings.'),
    ]
    indexType: Annotated[
        Optional[IndexType],
        Field(
            IndexType.Index,
            description='Whether the entity is index or index template.',
        ),
    ]
    sampleData: Annotated[
        Optional[SearchIndexSampleData],
        Field(None, description='Sample data for a searchIndex.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this searchIndex.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this searchIndex.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this searchIndex.'),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the SearchIndex belongs to. When not set, the SearchIndex inherits the domain from the messaging service it belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]


SearchIndexField.model_rebuild()
