# generated by datamodel-codegen:
#   filename:  entity/domains/domain.json
#   timestamp: 2025-07-18T13:46:59+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReference, entityReferenceList, tagLabel


class DomainType(Enum):
    Source_aligned = 'Source-aligned'
    Consumer_aligned = 'Consumer-aligned'
    Aggregate = 'Aggregate'


class Domain(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[basic.Uuid, Field(description='Unique ID of the Domain')]
    domainType: Annotated[DomainType, Field(description='Domain type')]
    name: Annotated[basic.EntityName, Field(description='A unique name of the Domain')]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description="Name used for display purposes. Example 'Marketing', 'Payments', etc.",
        ),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Description of the Domain.')
    ]
    style: Optional[basic.Style] = None
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    parent: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description="Parent domains. When 'null' or not set, indicates that this is the top level domain.",
        ),
    ]
    children: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Children domains or sub-domains.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this Domain.'),
    ]
    experts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of users who are experts in this Domain.'),
    ]
    assets: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Data assets collection that is part of this domain.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags associated with the Domain.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this entity.'),
    ]
