# generated by datamodel-codegen:
#   filename:  entity/services/connections/mlmodel/sageMakerConnection.json
#   timestamp: 2025-07-18T13:46:59+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import awsCredentials
from .....type import filterPattern
from .. import connectionBasicType


class SageMakerType(Enum):
    SageMaker = 'SageMaker'


class SageMakerConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[SageMakerType],
        Field(
            SageMakerType.SageMaker, description='Service Type', title='Service Type'
        ),
    ]
    awsConfig: Annotated[
        awsCredentials.AWSCredentials, Field(title='AWS Credentials Configuration')
    ]
    mlModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch MlModels with names matching the pattern.',
            title='Default ML Model Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
