# generated by datamodel-codegen:
#   filename:  entity/services/ingestionPipelines/ingestionPipeline.json
#   timestamp: 2025-07-18T13:46:59+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ....metadataIngestion import workflow
from ....type import basic, entityHistory, entityReference, entityReferenceList
from ..connections.metadata import openMetadataConnection
from . import status


class PipelineType(Enum):
    metadata = 'metadata'
    usage = 'usage'
    lineage = 'lineage'
    profiler = 'profiler'
    autoClassification = 'autoClassification'
    TestSuite = 'TestSuite'
    dataInsight = 'dataInsight'
    elasticSearchReindex = 'elasticSearchReindex'
    dbt = 'dbt'
    application = 'application'


class PipelineState(Enum):
    queued = 'queued'
    success = 'success'
    failed = 'failed'
    running = 'running'
    partialSuccess = 'partialSuccess'


class AirflowConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    pausePipeline: Annotated[
        Optional[bool],
        Field(
            False,
            description='pause the pipeline from running once the deploy is finished successfully.',
        ),
    ]
    concurrency: Annotated[
        Optional[int], Field(1, description='Concurrency of the Pipeline.')
    ]
    startDate: Annotated[
        Optional[basic.DateTime], Field(None, description='Start date of the pipeline.')
    ]
    endDate: Annotated[
        Optional[basic.DateTime], Field(None, description='End Date of the pipeline.')
    ]
    pipelineTimezone: Annotated[
        Optional[str],
        Field('UTC', description='Timezone in which pipeline going to be scheduled.'),
    ]
    retries: Annotated[
        Optional[int], Field(0, description='Retry pipeline in case of failure.')
    ]
    retryDelay: Annotated[
        Optional[int], Field(300, description='Delay between retries in seconds.')
    ]
    pipelineCatchup: Annotated[
        Optional[bool],
        Field(
            False, description='Run past executions if the start date is in the past.'
        ),
    ]
    scheduleInterval: Annotated[
        Optional[str],
        Field(None, description='Scheduler Interval for the pipeline in cron format.'),
    ]
    maxActiveRuns: Annotated[
        Optional[int], Field(1, description='Maximum Number of active runs.')
    ]
    workflowTimeout: Annotated[
        Optional[int], Field(None, description='Timeout for the workflow in seconds.')
    ]
    workflowDefaultView: Annotated[
        Optional[str], Field('tree', description='Default view in Airflow.')
    ]
    workflowDefaultViewOrientation: Annotated[
        Optional[str], Field('LR', description='Default view Orientation in Airflow.')
    ]
    email: Annotated[
        Optional[basic.Email],
        Field(None, description='Email to notify workflow status.'),
    ]


class PipelineStatus(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    runId: Annotated[Optional[str], Field(None, description='Pipeline unique run ID.')]
    pipelineState: Annotated[
        Optional[PipelineState],
        Field(None, description='Pipeline status denotes if its failed or succeeded.'),
    ]
    startDate: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='startDate of the pipeline run for this particular execution.',
        ),
    ]
    timestamp: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='executionDate of the pipeline run for this particular execution.',
        ),
    ]
    endDate: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='endDate of the pipeline run for this particular execution.',
        ),
    ]
    status: Annotated[
        Optional[status.IngestionStatus],
        Field(
            None,
            description='Ingestion Pipeline summary status. Informed at the end of the execution.',
        ),
    ]
    config: Annotated[
        Optional[basic.Map],
        Field(
            None, description='Pipeline configuration for this particular execution.'
        ),
    ]
    metadata: Annotated[
        Optional[basic.Map],
        Field(None, description='Metadata for the pipeline status.'),
    ]


class IngestionPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(None, description='Unique identifier that identifies this pipeline.'),
    ]
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this pipeline instance uniquely.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this Pipeline.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Pipeline.'),
    ]
    pipelineType: PipelineType
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this Pipeline.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='Name that uniquely identifies a Pipeline.'),
    ]
    sourceConfig: workflow.SourceConfig
    openMetadataServerConnection: Optional[
        openMetadataConnection.OpenMetadataConnection
    ] = None
    airflowConfig: AirflowConfig
    service: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Link to the service (such as database, messaging, storage services, etc. for which this ingestion pipeline ingests the metadata from.',
        ),
    ]
    pipelineStatuses: Annotated[
        Optional[PipelineStatus],
        Field(None, description='Last of executions and status for the Pipeline.'),
    ]
    loggerLevel: Annotated[
        Optional[workflow.LogLevels],
        Field(
            workflow.LogLevels.INFO,
            description='Set the logging level for the workflow.',
        ),
    ]
    raiseOnError: Annotated[
        Optional[bool],
        Field(
            True,
            description='Control if we want to flag the workflow as failed if we encounter any processing errors.',
        ),
    ]
    deployed: Annotated[
        Optional[bool],
        Field(
            False,
            description='Indicates if the workflow has been successfully deployed to Airflow.',
        ),
    ]
    enabled: Annotated[
        Optional[bool],
        Field(
            True,
            description='True if the pipeline is ready to be run in the next schedule. False if it is paused.',
        ),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to this ingestion pipeline resource.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that led to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
    applicationType: Annotated[
        Optional[str],
        Field(
            None,
            description="Type of the application when pipelineType is 'application'.",
        ),
    ]
    ingestionRunner: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='The ingestion agent responsible for executing the ingestion pipeline.',
        ),
    ]
