# generated by datamodel-codegen:
#   filename:  governance/workflows/elements/nodes/automatedTask/runAppTask.json
#   timestamp: 2025-07-18T13:46:59+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ......type import basic


class Config(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    appName: Annotated[
        str, Field(description='Set which App should Run', title='App Name')
    ]
    waitForCompletion: Annotated[
        bool,
        Field(
            description='Set if this step should wait until the App finishes running',
            title='Wait for Completion',
        ),
    ]
    timeoutSeconds: Annotated[
        int,
        Field(
            description='Set the amount of seconds to wait before defining the App has timed out.',
            title='Timeout Seconds',
        ),
    ]


class InputNamespaceMap(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    relatedEntity: str


class RunAppTaskDefinition(BaseModel):
    type: Optional[str] = 'automatedTask'
    subType: Optional[str] = 'runAppTask'
    name: Annotated[
        Optional[basic.EntityName],
        Field(None, description='Name that identifies this Node.', title='Name'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this Node.',
            title='Display Name',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Node.', title='Description'),
    ]
    config: Optional[Config] = None
    input: Annotated[
        Optional[List[str]], Field(['relatedEntity'], max_length=1, min_length=1)
    ]
    inputNamespaceMap: Optional[InputNamespaceMap] = None
    branches: Annotated[
        Optional[List[str]], Field(['success', 'failure'], max_length=2, min_length=2)
    ]
