# generated by datamodel-codegen:
#   filename:  type/usageDetails.json
#   timestamp: 2025-07-18T13:46:59+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic


class UsageStats(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: Annotated[
        int, Field(description='Usage count of a data asset on the start date.', ge=0)
    ]
    percentileRank: Annotated[
        Optional[float],
        Field(
            None,
            description='Optional daily percentile rank data asset use when relevant.',
            ge=0.0,
            le=100.0,
        ),
    ]


class UsageDetails(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dailyStats: Annotated[
        UsageStats,
        Field(description='Daily usage stats of a data asset on the start date.'),
    ]
    weeklyStats: Annotated[
        Optional[UsageStats],
        Field(
            None,
            description='Weekly (last 7 days) rolling usage stats of a data asset on the start date.',
        ),
    ]
    monthlyStats: Annotated[
        Optional[UsageStats],
        Field(
            None,
            description='Monthly (last 30 days) rolling usage stats of a data asset on the start date.',
        ),
    ]
    date: Annotated[basic.Date, Field(description='Date in UTC.')]
