
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.account.takeout import TypeAccountTakeout


class InitTakeoutSession(TLRequest[TypeAccountTakeout]):
    """
    Initialize a [takeout session, see here  for more info](https://core.telegram.org/api/takeout).

    Raises:
        `420`TakeoutInitDelayError: Sorry, for security reasons, you will be able to begin downloading your data in {seconds} seconds. We have notified all your devices about the export request to make sure it's authorized and to give you time to react if it's not.

    """

    _id = 0X8EF3EAB0
    _result_id = 0XBC7725C0

    def __init__(
        self,
        contacts: bool = False,
        message_users: bool = False,
        message_chats: bool = False,
        message_megagroups: bool = False,
        message_channels: bool = False,
        files: bool = False,
        file_max_size: Optional[int] = None
    ):

        """
        Initialize a [takeout session, see here  for more info](https://core.telegram.org/api/takeout).

        Args:
            contacts (bool, optional): Whether to export contacts
            message_users (bool, optional): Whether to export messages in private chats
            message_chats (bool, optional): Whether to export messages in [basic groups](https://core.telegram.org/api/channel#basic-groups)
            message_megagroups (bool, optional): Whether to export messages in [supergroups](https://core.telegram.org/api/channel#supergroups)
            message_channels (bool, optional): Whether to export messages in [channels](https://core.telegram.org/api/channel#channels)
            files (bool, optional): Whether to export files
            file_max_size (Optional[int], optional): Maximum size of files to export
        """

        self.contacts = contacts
        self.message_users = message_users
        self.message_chats = message_chats
        self.message_megagroups = message_megagroups
        self.message_channels = message_channels
        self.files = files
        self.file_max_size = file_max_size

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb0\xea\xf3\x8e' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.contacts, 0)
                flags(self.message_users, 1)
                flags(self.message_chats, 2)
                flags(self.message_megagroups, 3)
                flags(self.message_channels, 4)
                flags(self.files, 5)

                if flags(self.file_max_size, 5):
                    writer.long(self.file_max_size)

            return writer.getvalue()