
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.base_theme import TypeBaseTheme
    from ...types.input_theme import TypeInputTheme


class InstallTheme(TLRequest[bool]):
    """
    Install a theme
    """

    _id = 0XC727BB3B
    _result_id = 0X43B904E1

    def __init__(
        self,
        dark: bool = False,
        theme: Optional['TypeInputTheme'] = None,
        format: Optional[str] = None,
        base_theme: Optional['TypeBaseTheme'] = None
    ):

        """
        Install a theme

        Args:
            dark (bool, optional): Whether to install the dark version
            theme (Optional['TypeInputTheme'], optional): Theme to install
            format (Optional[str], optional): Theme format, a string that identifies the theming engines supported by the client
            base_theme (Optional['TypeBaseTheme'], optional): Indicates a basic theme provided by all clients
        """

        self.dark = dark
        self.theme = theme
        self.format = format
        self.base_theme = base_theme

    def to_bytes(self, boxed: bool=True):
        with Writer(b";\xbb'\xc7" if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.dark, 0)

                if flags(self.theme, 1):
                    writer.object(
                        self.theme,
                        group_id=0X339F9825
                    )

                if flags(self.format, 2):
                    writer.string(self.format)

                if flags(self.base_theme, 3):
                    writer.object(
                        self.base_theme,
                        group_id=0X4F42DD2D
                    )

            return writer.getvalue()