
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


class UnregisterDevice(TLRequest[bool]):
    """
    Deletes a device by its token, stops sending PUSH-notifications to it.

    Raises:
        `400`TokenInvalidError: The provided token is invalid.

    """

    _id = 0X6A0D3206
    _result_id = 0X43B904E1

    def __init__(
        self,
        token_type: int,
        token: str,
        other_uids: List[int]
    ):

        """
        Deletes a device by its token, stops sending PUSH-notifications to it.

        Args:
            token_type (int): Device token type, see [PUSH updates](https://core.telegram.org/api/push-updates#subscribing-to-notifications) for the possible values.
            token (str): Device token, see [PUSH updates](https://core.telegram.org/api/push-updates#subscribing-to-notifications) for the possible values.
            other_uids (List[int]): List of user identifiers of other users currently using the client
        """

        self.token_type = token_type
        self.token = token
        self.other_uids = other_uids

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x062\rj' if boxed else b'') as writer:
            writer.int(self.token_type)
            writer.string(self.token)
            writer.vector(
                self.other_uids,
                writer.long
            )

            return writer.getvalue()