
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.auth.authorization import TypeAuthAuthorization


class SignUp(TLRequest[TypeAuthAuthorization]):
    """
    Registers a validated phone number in the system.

    Raises:
        `400`FirstnameInvalidError: The first name is invalid.
        `400`LastnameInvalidError: The last name is invalid.
        `400`PhoneCodeEmptyError: phone_code is missing.
        `400`PhoneCodeExpiredError: The phone code you provided has expired.
        `400`PhoneCodeInvalidError: The provided phone code is invalid.
        `400`PhoneNumberFloodError: You asked for the code too many times.
        `400`PhoneNumberOccupiedError: The phone number is already in use.
        `406`PhoneNumberInvalidError: The phone number is invalid.

    """

    _id = 0XAAC7B717
    _result_id = 0X2A654890

    def __init__(
        self,
        phone_number: str,
        phone_code_hash: str,
        first_name: str,
        last_name: str,
        no_joined_notifications: bool = False
    ):

        """
        Registers a validated phone number in the system.

        Args:
            phone_number (str): Phone number in the international format
            phone_code_hash (str): SMS-message ID
            first_name (str): New user first name
            last_name (str): New user last name
            no_joined_notifications (bool, optional): If set, users on Telegram that have already added phone_number to their contacts will not receive signup notifications about this user.
        """

        self.phone_number = phone_number
        self.phone_code_hash = phone_code_hash
        self.first_name = first_name
        self.last_name = last_name
        self.no_joined_notifications = no_joined_notifications

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x17\xb7\xc7\xaa' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.no_joined_notifications, 0)
                writer.string(self.phone_number)
                writer.string(self.phone_code_hash)
                writer.string(self.first_name)
                writer.string(self.last_name)

            return writer.getvalue()