
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.star_ref_program import TypeStarRefProgram


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser


class UpdateStarRefProgram(TLRequest[TypeStarRefProgram]):
    """
    Create, edit or delete the [affiliate program](https://core.telegram.org/api/bots/referrals) of a bot we own

    Raises:
        `400`BotInvalidError: This is not a valid bot.
        `400`StarrefAwaitingEndError: The previous referral program was terminated less than 24 hours ago: further changes can be made after the date specified in userFull.starref_program.end_date.
        `400`StarrefPermilleInvalidError: The specified commission_permille is invalid: the minimum and maximum values for this parameter are contained in the [starref_min_commission_permille](https://core.telegram.org/api/config#starref-min-commission-permille) and [starref_max_commission_permille](https://core.telegram.org/api/config#starref-max-commission-permille) client configuration parameters.
        `400`StarrefPermilleTooLowError: The specified commission_permille is too low: the minimum and maximum values for this parameter are contained in the [starref_min_commission_permille](https://core.telegram.org/api/config#starref-min-commission-permille) and [starref_max_commission_permille](https://core.telegram.org/api/config#starref-max-commission-permille) client configuration parameters.

    """

    _id = 0X778B5AB3
    _result_id = 0X1A73AF29

    def __init__(
        self,
        bot: 'TypeInputUser',
        commission_permille: int,
        duration_months: Optional[int] = None
    ):

        """
        Create, edit or delete the [affiliate program](https://core.telegram.org/api/bots/referrals) of a bot we own

        Args:
            bot ('TypeInputUser'): The bot
            commission_permille (int): The permille commission rate: it indicates the share of Telegram Stars received by affiliates for every transaction made by users they referred inside of the bot.    The minimum and maximum values for this parameter are contained in the [starref_min_commission_permille](https://core.telegram.org/api/config#starref-min-commission-permille) and [starref_max_commission_permille](https://core.telegram.org/api/config#starref-max-commission-permille) client configuration parameters.   Can be 0 to terminate the affiliate program.   Both the duration and the commission may only be raised after creation of the program: to lower them, the program must first be terminated and a new one created.
            duration_months (Optional[int], optional): Indicates the duration of the affiliate program; if not set, there is no expiration date.
        """

        self.bot = bot
        self.commission_permille = commission_permille
        self.duration_months = duration_months

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb3Z\x8bw' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.bot,
                    group_id=0XB628962F
                )
                writer.int(self.commission_permille)

                if flags(self.duration_months, 0):
                    writer.int(self.duration_months)

            return writer.getvalue()