
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_geo_point import TypeInputGeoPoint


class CreateChannel(TLRequest[TypeUpdates]):
    """
    Create a [supergroup/channel](https://core.telegram.org/api/channel).

    Raises:
        `400`AddressInvalidError: The specified geopoint address is invalid.
        `400`ChannelsAdminLocatedTooMuchError: The user has reached the limit of public geogroups.
        `400`ChannelsTooMuchError: You have joined too many channels/supergroups.
        `400`ChatAboutTooLongError: Chat about too long.
        `400`ChatTitleEmptyError: No chat title provided.
        `400`TtlPeriodInvalidError: The specified TTL period is invalid.
        `500`ChatInvalidError: Invalid chat.
        `406`UserRestrictedError: You're spamreported, you can't create channels or chats.

    """

    _id = 0X91006707
    _result_id = 0XD68D29C0

    def __init__(
        self,
        title: str,
        about: str,
        broadcast: bool = False,
        megagroup: bool = False,
        for_import: bool = False,
        forum: bool = False,
        geo_point: Optional['TypeInputGeoPoint'] = None,
        address: Optional[str] = None,
        ttl_period: Optional[int] = None
    ):

        """
        Create a [supergroup/channel](https://core.telegram.org/api/channel).

        Args:
            title (str): Channel title
            about (str): Channel description
            broadcast (bool, optional): Whether to create a [channel](https://core.telegram.org/api/channel)
            megagroup (bool, optional): Whether to create a [supergroup](https://core.telegram.org/api/channel)
            for_import (bool, optional): Whether the supergroup is being created to import messages from a foreign chat service using [messages.initHistoryImport](https://core.telegram.org/method/messages.initHistoryImport)
            forum (bool, optional): Whether to create a [forum](https://core.telegram.org/api/forum)
            geo_point (Optional['TypeInputGeoPoint'], optional): Geogroup location, see [here](https://core.telegram.org/api/nearby) for more info on geogroups.
            address (Optional[str], optional): Geogroup address, see [here](https://core.telegram.org/api/nearby) for more info on geogroups.
            ttl_period (Optional[int], optional): Time-to-live of all messages that will be sent in the supergroup: once message.date+message.ttl_period === time(), the message will be deleted on the server, and must be deleted locally as well. You can use [messages.setDefaultHistoryTTL](https://core.telegram.org/method/messages.setDefaultHistoryTTL) to edit this value later.
        """

        self.title = title
        self.about = about
        self.broadcast = broadcast
        self.megagroup = megagroup
        self.for_import = for_import
        self.forum = forum
        self.geo_point = geo_point
        self.address = address
        self.ttl_period = ttl_period

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x07g\x00\x91' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.broadcast, 0)
                flags(self.megagroup, 1)
                flags(self.for_import, 3)
                flags(self.forum, 5)
                writer.string(self.title)
                writer.string(self.about)

                if flags(self.geo_point, 2):
                    writer.object(
                        self.geo_point,
                        group_id=0XF78B3873
                    )

                if flags(self.address, 2):
                    writer.string(self.address)

                if flags(self.ttl_period, 4):
                    writer.int(self.ttl_period)

            return writer.getvalue()