
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Long, Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_channel import TypeInputChannel


class CreateForumTopic(TLRequest[TypeUpdates]):
    """
    Create a [forum topic](https://core.telegram.org/api/forum); requires [manage_topics rights](https://core.telegram.org/api/rights).

    **Bots can use this method**

    Raises:
        `400`ChannelForumMissingError: This supergroup is not a forum.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`TopicTitleEmptyError: The specified topic title is empty.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `403`PremiumAccountRequiredError: A premium account is required to execute this action.

    """

    _id = 0XF40C0224
    _result_id = 0XD68D29C0

    def __init__(
        self,
        channel: 'TypeInputChannel',
        title: str,
        icon_color: Optional[int] = None,
        icon_emoji_id: Optional[int] = None,
        send_as: Optional['TypeInputPeer'] = None,
        random_id: int = None
    ):

        """
        Create a [forum topic](https://core.telegram.org/api/forum); requires [manage_topics rights](https://core.telegram.org/api/rights).

        **Bots can use this method**

        Args:
            channel ('TypeInputChannel'): [The forum](https://core.telegram.org/api/forum)
            title (str): Topic title (maximum UTF-8 length: 128)
            icon_color (Optional[int], optional): If no custom emoji icon is specified, specifies the color of the fallback topic icon (RGB), one of 0x6FB9F0, 0xFFD67E, 0xCB86DB, 0x8EEE98, 0xFF93B2, or 0xFB6F5F.
            icon_emoji_id (Optional[int], optional): ID of the [custom emoji](https://core.telegram.org/api/custom-emoji) used as topic icon. [Telegram Premium](https://core.telegram.org/api/premium) users can use any custom emoji, other users can only use the custom emojis contained in the [inputStickerSetEmojiDefaultTopicIcons](https://core.telegram.org/constructor/inputStickerSetEmojiDefaultTopicIcons) emoji pack.
            send_as (Optional['TypeInputPeer'], optional): Create the topic as the specified peer
            random_id (int, optional): Unique client message ID to prevent duplicate sending of the same event
        """

        self.channel = channel
        self.title = title
        self.icon_color = icon_color
        self.icon_emoji_id = icon_emoji_id
        self.send_as = send_as
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'$\x02\x0c\xf4' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.channel,
                    group_id=0X42691CEF
                )
                writer.string(self.title)

                if flags(self.icon_color, 0):
                    writer.int(self.icon_color)

                if flags(self.icon_emoji_id, 3):
                    writer.long(self.icon_emoji_id)
                writer.long(self.random_id)

                if flags(self.send_as, 2):
                    writer.object(
                        self.send_as,
                        group_id=0X995DB9DF
                    )

            return writer.getvalue()