
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_channel import TypeInputChannel
    from ...types.chat_banned_rights import TypeChatBannedRights


class EditBanned(TLRequest[TypeUpdates]):
    """
    Ban/unban/kick a user in a [supergroup/channel](https://core.telegram.org/api/channel).

    **Bots can use this method**

    Raises:
        `406`BannedRightsInvalidError: You provided some invalid flags in the banned rights.
        `406`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`ParticipantIdInvalidError: The specified participant ID is invalid.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`UserAdminInvalidError: You're not an admin.
        `400`UserIdInvalidError: The provided user ID is invalid.
        `403`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `403`ChatWriteForbiddenError: You can't write in this chat.

    """

    _id = 0X96E6CD81
    _result_id = 0XD68D29C0

    def __init__(
        self,
        channel: 'TypeInputChannel',
        participant: 'TypeInputPeer',
        banned_rights: 'TypeChatBannedRights'
    ):

        """
        Ban/unban/kick a user in a [supergroup/channel](https://core.telegram.org/api/channel).

        **Bots can use this method**

        Args:
            channel ('TypeInputChannel'): The [supergroup/channel](https://core.telegram.org/api/channel).
            participant ('TypeInputPeer'): Participant to ban
            banned_rights ('TypeChatBannedRights'): The banned rights
        """

        self.channel = channel
        self.participant = participant
        self.banned_rights = banned_rights

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x81\xcd\xe6\x96' if boxed else b'') as writer:
            writer.object(
                self.channel,
                group_id=0X42691CEF
            )
            writer.object(
                self.participant,
                group_id=0X995DB9DF
            )
            writer.object(
                self.banned_rights,
                group_id=0XDB47663A
            )

            return writer.getvalue()