
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.exported_chatlist_invite import TypeExportedChatlistInvite


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_chatlist import TypeInputChatlist


class EditExportedInvite(TLRequest[TypeExportedChatlistInvite]):
    """
    Edit a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`FilterIdInvalidError: The specified filter ID is invalid.
        `400`FilterNotSupportedError: The specified filter cannot be used in this context.
        `400`InviteSlugEmptyError: The specified invite slug is empty.
        `400`InviteSlugExpiredError: The specified chat folder link has expired.
        `400`PeersListEmptyError: The specified list of peers is empty.

    """

    _id = 0X653DB63D
    _result_id = 0XD53D8947

    def __init__(
        self,
        chatlist: 'TypeInputChatlist',
        slug: str,
        title: Optional[str] = None,
        peers: Optional[List['TypeInputPeer']] = None
    ):

        """
        Edit a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).

        Args:
            chatlist ('TypeInputChatlist'): Folder ID
            slug (str): slug obtained from the [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).
            title (Optional[str], optional): If set, sets a new name for the link
            peers (Optional[List['TypeInputPeer']], optional): If set, changes the list of peers shared with the link
        """

        self.chatlist = chatlist
        self.slug = slug
        self.title = title
        self.peers = peers

    def to_bytes(self, boxed: bool=True):
        with Writer(b'=\xb6=e' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.chatlist,
                    group_id=0XF1847C0F
                )
                writer.string(self.slug)

                if flags(self.title, 1):
                    writer.string(self.title)

                if flags(self.peers, 2):
                    writer.vector(
                        self.peers,
                        lambda value: writer.object(
                            value,
                            group_id=0X995DB9DF
                        )
                    )

            return writer.getvalue()