
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.invited_users import TypeMessagesInvitedUsers


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser


class AddChatUser(TLRequest[TypeMessagesInvitedUsers]):
    """
    Adds a user to a chat and sends a service message on it.

    Raises:
        `400`BotGroupsBlockedError: This bot can't be added to groups.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`UsersTooMuchError: The maximum number of users has been exceeded (to create a chat, for example).
        `400`UserAlreadyParticipantError: The user is already in the group.
        `400`UserIdInvalidError: The provided user ID is invalid.
        `400`UserIsBlockedError: You were blocked by this user.
        `400`YouBlockedUserError: You blocked this user.
        `403`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `403`UserNotMutualContactError: The provided user is not a mutual contact.
        `403`UserPrivacyRestrictedError: The user's privacy settings do not allow you to do this.

    """

    _id = 0XCBC6D107
    _result_id = 0X5D9C0B42

    def __init__(
        self,
        chat_id: int,
        user_id: 'TypeInputUser',
        fwd_limit: int
    ):

        """
        Adds a user to a chat and sends a service message on it.

        Args:
            chat_id (int): Chat ID
            user_id ('TypeInputUser'): User ID to be added
            fwd_limit (int): Number of last messages to be forwarded
        """

        self.chat_id = chat_id
        self.user_id = user_id
        self.fwd_limit = fwd_limit

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x07\xd1\xc6\xcb' if boxed else b'') as writer:
            writer.long(self.chat_id)
            writer.object(
                self.user_id,
                group_id=0XB628962F
            )
            writer.int(self.fwd_limit)

            return writer.getvalue()