
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Long, Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_reply_to import TypeInputReplyTo
    from ...types.suggested_post import TypeSuggestedPost
    from ...types.input_quick_reply_shortcut import TypeInputQuickReplyShortcut


class ForwardMessages(TLRequest[TypeUpdates]):
    """
    Forwards messages by their IDs.

    **Bots can use this method**

    Raises:
        `400`BroadcastPublicVotersForbiddenError: You can't forward polls with public voters.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`ChatRestrictedError: You can't send messages in this chat, you were restricted.
        `400`GroupedMediaInvalidError: Invalid grouped media.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MediaEmptyError: The provided media object is invalid.
        `400`MessageIdsEmptyError: No message ids were provided.
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`QuickRepliesTooMuchError: A maximum of [appConfig.`quick_replies_limit`](https://core.telegram.org/api/config#quick-replies-limit) shortcuts may be created, the limit was reached.
        `400`QuizAnswerMissingError: You can forward a quiz while hiding the original author only after choosing an option in the quiz.
        `400`RandomIdInvalidError: A provided random ID is invalid.
        `400`ReplyMessagesTooMuchError: Each shortcut can contain a maximum of [appConfig.`quick_reply_messages_limit`](https://core.telegram.org/api/config#quick-reply-messages-limit) messages, the limit was reached.
        `400`ScheduleBotNotAllowedError: Bots cannot schedule messages.
        `400`ScheduleDateTooLateError: You can't schedule a message this far in the future.
        `400`ScheduleTooMuchError: There are too many scheduled messages.
        `400`SendAsPeerInvalidError: You can't send messages as the specified peer.
        `400`SlowmodeMultiMsgsDisabledError: Slowmode is enabled, you cannot forward multiple messages to this group.
        `400`UserBannedInChannelError: You're banned from sending messages in supergroups/channels.
        `400`UserIsBotError: Bots can't send messages to other bots.
        `400`YouBlockedUserError: You blocked this user.
        `406`ChannelPrivateError: You haven't joined this channel/supergroup.
        `406`ChatForwardsRestrictedError: You can't forward messages from a protected chat.
        `406`PaymentUnsupportedError: A detailed description of the error will be received separately as described [here &raquo;](https://core.telegram.org/api/errors#406-not-acceptable).
        `406`PrivacyPremiumRequiredError: You need a [Telegram Premium subscription](https://core.telegram.org/api/premium) to send a message to this user.
        `406`TopicClosedError: This topic was closed, you can't send messages to it anymore.
        `406`TopicDeletedError: The specified topic was deleted.
        `403`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `403`ChatGuestSendForbiddenError: You join the discussion group before commenting, see [here &raquo;](https://core.telegram.org/api/discussion#requiring-users-to-join-the-group) for more info.
        `403`ChatSendAudiosForbiddenError: You can't send audio messages in this chat.
        `403`ChatSendDocsForbiddenError: You can't send documents in this chat.
        `403`ChatSendGameForbiddenError: You can't send a game to this chat.
        `403`ChatSendGifsForbiddenError: You can't send gifs in this chat.
        `403`ChatSendMediaForbiddenError: You can't send media in this chat.
        `403`ChatSendPhotosForbiddenError: You can't send photos in this chat.
        `403`ChatSendPlainForbiddenError: You can't send non-media (text) messages in this chat.
        `403`ChatSendPollForbiddenError: You can't send polls in this chat.
        `403`ChatSendStickersForbiddenError: You can't send stickers in this chat.
        `403`ChatSendVideosForbiddenError: You can't send videos in this chat.
        `403`ChatSendVoicesForbiddenError: You can't send voice recordings in this chat.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `403`PremiumAccountRequiredError: A premium account is required to execute this action.
        `403`UserIsBlockedError: You were blocked by this user.
        `403`VoiceMessagesForbiddenError: This user's privacy settings forbid you from sending voice messages.
        `500`RandomIdDuplicateError: You provided a random ID that was already used.
        `420`SlowmodeWaitError: Slowmode is enabled in this chat: wait {seconds} seconds before sending another message to this chat.

    """

    _id = 0X978928CA
    _result_id = 0XD68D29C0

    def __init__(
        self,
        from_peer: 'TypeInputPeer',
        id: List[int],
        to_peer: 'TypeInputPeer',
        silent: bool = False,
        background: bool = False,
        with_my_score: bool = False,
        drop_author: bool = False,
        drop_media_captions: bool = False,
        noforwards: bool = False,
        allow_paid_floodskip: bool = False,
        top_msg_id: Optional[int] = None,
        reply_to: Optional['TypeInputReplyTo'] = None,
        schedule_date: Optional[int] = None,
        send_as: Optional['TypeInputPeer'] = None,
        quick_reply_shortcut: Optional['TypeInputQuickReplyShortcut'] = None,
        video_timestamp: Optional[int] = None,
        allow_paid_stars: Optional[int] = None,
        suggested_post: Optional['TypeSuggestedPost'] = None,
        random_id: List[int] = None
    ):

        """
        Forwards messages by their IDs.

        **Bots can use this method**

        Args:
            from_peer ('TypeInputPeer'): Source of messages
            id (List[int]): IDs of messages
            to_peer ('TypeInputPeer'): Destination peer
            silent (bool, optional): Whether to send messages silently (no notification will be triggered on the destination clients)
            background (bool, optional): Whether to send the message in background
            with_my_score (bool, optional): When forwarding games, whether to include your score in the game
            drop_author (bool, optional): Whether to forward messages without quoting the original author
            drop_media_captions (bool, optional): Whether to strip captions from media
            noforwards (bool, optional): Only for bots, disallows further re-forwarding and saving of the messages, even if the destination chat doesn't have [content protection](https://telegram.org/blog/protected-content-delete-by-date-and-more) enabled
            allow_paid_floodskip (bool, optional): Bots only: if set, allows sending up to 1000 messages per second, ignoring [broadcasting limits](https://core.telegram.org/bots/faq#how-can-i-message-all-of-my-bot-39s-subscribers-at-once) for a fee of 0.1 Telegram Stars per message. The relevant Stars will be withdrawn from the bot's balance.
            top_msg_id (Optional[int], optional): Destination [forum topic](https://core.telegram.org/api/forum#forum-topics)
            reply_to (Optional['TypeInputReplyTo'], optional): ...
            schedule_date (Optional[int], optional): Scheduled message date for scheduled messages
            send_as (Optional['TypeInputPeer'], optional): Forward the messages as the specified peer
            quick_reply_shortcut (Optional['TypeInputQuickReplyShortcut'], optional): Add the messages to the specified [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts), instead.
            video_timestamp (Optional[int], optional): ...
            allow_paid_stars (Optional[int], optional): ...
            suggested_post (Optional['TypeSuggestedPost'], optional): ...
            random_id (List[int], optional): Random ID to prevent resending of messages
        """

        self.from_peer = from_peer
        self.id = id
        self.to_peer = to_peer
        self.silent = silent
        self.background = background
        self.with_my_score = with_my_score
        self.drop_author = drop_author
        self.drop_media_captions = drop_media_captions
        self.noforwards = noforwards
        self.allow_paid_floodskip = allow_paid_floodskip
        self.top_msg_id = top_msg_id
        self.reply_to = reply_to
        self.schedule_date = schedule_date
        self.send_as = send_as
        self.quick_reply_shortcut = quick_reply_shortcut
        self.video_timestamp = video_timestamp
        self.allow_paid_stars = allow_paid_stars
        self.suggested_post = suggested_post
        self.random_id = [Long() for _ in id] if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xca(\x89\x97' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.silent, 5)
                flags(self.background, 6)
                flags(self.with_my_score, 8)
                flags(self.drop_author, 11)
                flags(self.drop_media_captions, 12)
                flags(self.noforwards, 14)
                flags(self.allow_paid_floodskip, 19)
                writer.object(
                    self.from_peer,
                    group_id=0X995DB9DF
                )
                writer.vector(
                    self.id,
                    writer.int
                )
                writer.vector(
                    self.random_id,
                    writer.long
                )
                writer.object(
                    self.to_peer,
                    group_id=0X995DB9DF
                )

                if flags(self.top_msg_id, 9):
                    writer.int(self.top_msg_id)

                if flags(self.reply_to, 22):
                    writer.object(
                        self.reply_to,
                        group_id=0X8EEA0D0F
                    )

                if flags(self.schedule_date, 10):
                    writer.int(self.schedule_date)

                if flags(self.send_as, 13):
                    writer.object(
                        self.send_as,
                        group_id=0X995DB9DF
                    )

                if flags(self.quick_reply_shortcut, 17):
                    writer.object(
                        self.quick_reply_shortcut,
                        group_id=0X60706B98
                    )

                if flags(self.video_timestamp, 20):
                    writer.int(self.video_timestamp)

                if flags(self.allow_paid_stars, 21):
                    writer.long(self.allow_paid_stars)

                if flags(self.suggested_post, 23):
                    writer.object(
                        self.suggested_post,
                        group_id=0X7DC96856
                    )

            return writer.getvalue()