
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.bot_callback_answer import TypeMessagesBotCallbackAnswer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_check_password_srp import TypeInputCheckPasswordSRP


class GetBotCallbackAnswer(TLRequest[TypeMessagesBotCallbackAnswer]):
    """
    Press an inline callback button and get a callback answer from the bot

    Raises:
        `400`BotResponseTimeoutError: A timeout occurred while fetching data from the bot.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`DataInvalidError: Encrypted data invalid.
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`PasswordMissingError: You must [enable 2FA](https://core.telegram.org/api/srp) before executing this operation.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X9342CA07
    _result_id = 0X374CF30F

    def __init__(
        self,
        peer: 'TypeInputPeer',
        msg_id: int,
        game: bool = False,
        data: Optional[bytes] = None,
        password: Optional['TypeInputCheckPasswordSRP'] = None
    ):

        """
        Press an inline callback button and get a callback answer from the bot

        Args:
            peer ('TypeInputPeer'): Where was the inline keyboard sent
            msg_id (int): ID of the Message with the inline keyboard
            game (bool, optional): Whether this is a "play game" button
            data (Optional[bytes], optional): Callback data
            password (Optional['TypeInputCheckPasswordSRP'], optional): For buttons [requiring you to verify your identity with your 2FA password](https://core.telegram.org/constructor/keyboardButtonCallback), the SRP payload generated using [SRP](https://core.telegram.org/api/srp).
        """

        self.peer = peer
        self.msg_id = msg_id
        self.game = game
        self.data = data
        self.password = password

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x07\xcaB\x93' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.game, 1)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.msg_id)

                if flags(self.data, 0):
                    writer.bytes(self.data)

                if flags(self.password, 2):
                    writer.object(
                        self.password,
                        group_id=0X9F1A3F43
                    )

            return writer.getvalue()