
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.dialogs import TypeMessagesDialogs


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetDialogs(TLRequest[TypeMessagesDialogs]):
    """
    Returns the current user dialog list.

    Raises:
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `400`FolderIdInvalidError: Invalid folder ID.
        `400`OffsetPeerIdInvalidError: The provided offset peer is invalid.
        `400`TakeoutInvalidError: The specified takeout ID is invalid.

    """

    _id = 0XA0F4CB4F
    _result_id = 0X6DE0E6BF

    def __init__(
        self,
        offset_date: int,
        offset_id: int,
        offset_peer: 'TypeInputPeer',
        limit: int,
        hash: int,
        exclude_pinned: bool = False,
        folder_id: Optional[int] = None
    ):

        """
        Returns the current user dialog list.

        Args:
            offset_date (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            offset_id (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets) ( top_message ID used for pagination)
            offset_peer ('TypeInputPeer'): [Offset peer for pagination](https://core.telegram.org/api/offsets)
            limit (int): Number of list elements to be returned
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            exclude_pinned (bool, optional): Exclude pinned dialogs
            folder_id (Optional[int], optional): [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
        """

        self.offset_date = offset_date
        self.offset_id = offset_id
        self.offset_peer = offset_peer
        self.limit = limit
        self.hash = hash
        self.exclude_pinned = exclude_pinned
        self.folder_id = folder_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'O\xcb\xf4\xa0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.exclude_pinned, 0)

                if flags(self.folder_id, 1):
                    writer.int(self.folder_id)
                writer.int(self.offset_date)
                writer.int(self.offset_id)
                writer.object(
                    self.offset_peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.limit)
                writer.long(self.hash)

            return writer.getvalue()