
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.outbox_read_date import TypeOutboxReadDate


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetOutboxReadDate(TLRequest[TypeOutboxReadDate]):
    """
    Get the exact read date of one of our messages, sent to a private chat with another user.

    Raises:
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`MessageNotReadYetError: The specified message wasn't read yet.
        `400`MessageTooOldError: The message is too old, the requested information is not available.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `403`UserPrivacyRestrictedError: The user's privacy settings do not allow you to do this.
        `403`YourPrivacyRestrictedError: You cannot fetch the read date of this message because you have disallowed other users to do so for *your* messages; to fix, allow other users to see *your* exact last online date OR purchase a [Telegram Premium](https://core.telegram.org/api/premium) subscription.

    """

    _id = 0X8C4BFE5D
    _result_id = 0XEDAACCED

    def __init__(
        self,
        peer: 'TypeInputPeer',
        msg_id: int
    ):

        """
        Get the exact read date of one of our messages, sent to a private chat with another user.

        Args:
            peer ('TypeInputPeer'): The user to whom we sent the message.
            msg_id (int): The message ID.
        """

        self.peer = peer
        self.msg_id = msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b']\xfeK\x8c' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.msg_id)

            return writer.getvalue()