
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.messages import TypeMessagesMessages


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetSavedHistory(TLRequest[TypeMessagesMessages]):
    """
    Returns [saved messages](https://core.telegram.org/api/saved-messages) forwarded from a specific peer

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X998AB009
    _result_id = 0XC8BB9188

    def __init__(
        self,
        peer: 'TypeInputPeer',
        offset_id: int,
        offset_date: int,
        add_offset: int,
        limit: int,
        max_id: int,
        min_id: int,
        hash: int,
        parent_peer: Optional['TypeInputPeer'] = None
    ):

        """
        Returns [saved messages](https://core.telegram.org/api/saved-messages) forwarded from a specific peer

        Args:
            peer ('TypeInputPeer'): Target peer
            offset_id (int): Only return messages starting from the specified message ID
            offset_date (int): Only return messages sent before the specified date
            add_offset (int): Number of list elements to be skipped, negative values are also accepted.
            limit (int): Number of results to return
            max_id (int): If a positive value was transferred, the method will return only messages with IDs less than max_id
            min_id (int): If a positive value was transferred, the method will return only messages with IDs more than min_id
            hash (int): [Result hash](https://core.telegram.org/api/offsets)
            parent_peer (Optional['TypeInputPeer'], optional): ...
        """

        self.peer = peer
        self.offset_id = offset_id
        self.offset_date = offset_date
        self.add_offset = add_offset
        self.limit = limit
        self.max_id = max_id
        self.min_id = min_id
        self.hash = hash
        self.parent_peer = parent_peer

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\t\xb0\x8a\x99' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.parent_peer, 0):
                    writer.object(
                        self.parent_peer,
                        group_id=0X995DB9DF
                    )
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.offset_id)
                writer.int(self.offset_date)
                writer.int(self.add_offset)
                writer.int(self.limit)
                writer.int(self.max_id)
                writer.int(self.min_id)
                writer.long(self.hash)

            return writer.getvalue()