
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


class ImportChatInvite(TLRequest[TypeUpdates]):
    """
    Import a chat invite and join a private chat/supergroup/channel

    Raises:
        `400`ChannelsTooMuchError: You have joined too many channels/supergroups.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatInvalidError: Invalid chat.
        `400`InviteHashEmptyError: The invite hash is empty.
        `400`InviteHashInvalidError: The invite hash is invalid.
        `400`InviteRequestSentError: You have successfully requested to join this chat or channel.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`StarsPaymentRequiredError: To import this chat invite link, you must first [pay for the associated Telegram Star subscription &raquo;](https://core.telegram.org/api/subscriptions#channel-subscriptions).
        `400`UsersTooMuchError: The maximum number of users has been exceeded (to create a chat, for example).
        `400`UserAlreadyParticipantError: The user is already in the group.
        `400`UserChannelsTooMuchError: One of the users you tried to add is already in too many channels/supergroups.
        `406`InviteHashExpiredError: The invite link has expired.

    """

    _id = 0X6C50051C
    _result_id = 0XD68D29C0

    def __init__(
        self,
        hash: str
    ):

        """
        Import a chat invite and join a private chat/supergroup/channel

        Args:
            hash (str): hash from a [chat invite deep link](https://core.telegram.org/api/links#chat-invite-links)
        """

        self.hash = hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1c\x05Pl' if boxed else b'') as writer:
            writer.string(self.hash)

            return writer.getvalue()