
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.affected_history import TypeMessagesAffectedHistory


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class ReadMentions(TLRequest[TypeMessagesAffectedHistory]):
    """
    Mark mentions as read

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X36E5BF4D
    _result_id = 0XC038BDBA

    def __init__(
        self,
        peer: 'TypeInputPeer',
        top_msg_id: Optional[int] = None
    ):

        """
        Mark mentions as read

        Args:
            peer ('TypeInputPeer'): Dialog
            top_msg_id (Optional[int], optional): Mark as read only mentions within the specified [forum topic](https://core.telegram.org/api/forum#forum-topics)
        """

        self.peer = peer
        self.top_msg_id = top_msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'M\xbf\xe56' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.top_msg_id, 0):
                    writer.int(self.top_msg_id)

            return writer.getvalue()