
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.web_view_result import TypeWebViewResult


if TYPE_CHECKING:
    from ...types.data_json import TypeDataJSON
    from ...types.input_peer import TypeInputPeer
    from ...types.input_user import TypeInputUser


class RequestMainWebView(TLRequest[TypeWebViewResult]):
    """
    Open a [Main Mini App](https://core.telegram.org/api/bots/webapps#main-mini-apps).

    Raises:
        `400`BotInvalidError: This is not a valid bot.

    """

    _id = 0XC9E01E7B
    _result_id = 0X60754D10

    def __init__(
        self,
        peer: 'TypeInputPeer',
        bot: 'TypeInputUser',
        platform: str,
        compact: bool = False,
        fullscreen: bool = False,
        start_param: Optional[str] = None,
        theme_params: Optional['TypeDataJSON'] = None
    ):

        """
        Open a [Main Mini App](https://core.telegram.org/api/bots/webapps#main-mini-apps).

        Args:
            peer ('TypeInputPeer'): Currently open chat, may be [inputPeerEmpty](https://core.telegram.org/constructor/inputPeerEmpty) if no chat is currently open.
            bot ('TypeInputUser'): Bot that owns the main mini app.
            platform (str): Short name of the application; 0-64 English letters, digits, and underscores
            compact (bool, optional): If set, requests to open the mini app in compact mode (as opposed to normal or fullscreen mode). Must be set if the mode parameter of the [Main Mini App link](https://core.telegram.org/api/links#main-mini-app-links) is equal to compact.
            fullscreen (bool, optional): If set, requests to open the mini app in fullscreen mode (as opposed to compact or normal mode). Must be set if the mode parameter of the [Main Mini App link](https://core.telegram.org/api/links#main-mini-app-links) is equal to fullscreen.
            start_param (Optional[str], optional): Start parameter, if opening from a [Main Mini App link](https://core.telegram.org/api/links#main-mini-app-links).
            theme_params (Optional['TypeDataJSON'], optional): [Theme parameters](https://core.telegram.org/api/bots/webapps#theme-parameters)
        """

        self.peer = peer
        self.bot = bot
        self.platform = platform
        self.compact = compact
        self.fullscreen = fullscreen
        self.start_param = start_param
        self.theme_params = theme_params

    def to_bytes(self, boxed: bool=True):
        with Writer(b'{\x1e\xe0\xc9' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.compact, 7)
                flags(self.fullscreen, 8)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.object(
                    self.bot,
                    group_id=0XB628962F
                )

                if flags(self.start_param, 1):
                    writer.string(self.start_param)

                if flags(self.theme_params, 0):
                    writer.object(
                        self.theme_params,
                        group_id=0XE95B0798
                    )
                writer.string(self.platform)

            return writer.getvalue()