
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.found_stickers import TypeMessagesFoundStickers


class SearchStickers(TLRequest[TypeMessagesFoundStickers]):
    """
    Search for stickers using AI-powered keyword search
    """

    _id = 0X29B1C66A
    _result_id = 0X3F23B008

    def __init__(
        self,
        q: str,
        emoticon: str,
        lang_code: List[str],
        offset: int,
        limit: int,
        hash: int,
        emojis: bool = False
    ):

        """
        Search for stickers using AI-powered keyword search

        Args:
            q (str): The search term
            emoticon (str): Space-separated list of emojis to search for
            lang_code (List[str]): List of possible IETF language tags of the user's input language; may be empty if unknown
            offset (int): [Offset for pagination](https://core.telegram.org/api/offsets)
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation). The hash may be generated locally by using the ids of the returned or stored sticker [document](https://core.telegram.org/constructor/document)s.
            emojis (bool, optional): If set, returns [custom emoji stickers](https://core.telegram.org/api/custom-emoji)
        """

        self.q = q
        self.emoticon = emoticon
        self.lang_code = lang_code
        self.offset = offset
        self.limit = limit
        self.hash = hash
        self.emojis = emojis

    def to_bytes(self, boxed: bool=True):
        with Writer(b'j\xc6\xb1)' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.emojis, 0)
                writer.string(self.q)
                writer.string(self.emoticon)
                writer.vector(
                    self.lang_code,
                    writer.string
                )
                writer.int(self.offset)
                writer.int(self.limit)
                writer.long(self.hash)

            return writer.getvalue()