
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Long, Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_reply_to import TypeInputReplyTo
    from ...types.input_quick_reply_shortcut import TypeInputQuickReplyShortcut


class SendInlineBotResult(TLRequest[TypeUpdates]):
    """
    Send a result obtained using [messages.getInlineBotResults](https://core.telegram.org/method/messages.getInlineBotResults).

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatRestrictedError: You can't send messages in this chat, you were restricted.
        `400`EntityBoundsInvalidError: A specified [entity offset or length](https://core.telegram.org/api/entities#entity-length) is invalid, see [here &raquo;](https://core.telegram.org/api/entities#entity-length) for info on how to properly compute the entity offset/length.
        `400`InlineResultExpiredError: The inline query expired.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MediaEmptyError: The provided media object is invalid.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`QueryIdEmptyError: The query ID is empty.
        `400`QuickRepliesTooMuchError: A maximum of [appConfig.`quick_replies_limit`](https://core.telegram.org/api/config#quick-replies-limit) shortcuts may be created, the limit was reached.
        `400`ReplyMessagesTooMuchError: Each shortcut can contain a maximum of [appConfig.`quick_reply_messages_limit`](https://core.telegram.org/api/config#quick-reply-messages-limit) messages, the limit was reached.
        `400`ResultIdEmptyError: Result ID empty.
        `400`ResultIdInvalidError: One of the specified result IDs is invalid.
        `400`ScheduleDateTooLateError: You can't schedule a message this far in the future.
        `400`ScheduleTooMuchError: There are too many scheduled messages.
        `400`TopicDeletedError: The specified topic was deleted.
        `400`UserBannedInChannelError: You're banned from sending messages in supergroups/channels.
        `400`VoiceMessagesForbiddenError: This user's privacy settings forbid you from sending voice messages.
        `400`WebpageCurlFailedError: Failure while fetching the webpage with cURL.
        `400`WebpageMediaEmptyError: Webpage media empty.
        `400`YouBlockedUserError: You blocked this user.
        `403`ChatGuestSendForbiddenError: You join the discussion group before commenting, see [here &raquo;](https://core.telegram.org/api/discussion#requiring-users-to-join-the-group) for more info.
        `403`ChatSendAudiosForbiddenError: You can't send audio messages in this chat.
        `403`ChatSendGameForbiddenError: You can't send a game to this chat.
        `403`ChatSendGifsForbiddenError: You can't send gifs in this chat.
        `403`ChatSendInlineForbiddenError: You can't send inline messages in this group.
        `403`ChatSendMediaForbiddenError: You can't send media in this chat.
        `403`ChatSendPhotosForbiddenError: You can't send photos in this chat.
        `403`ChatSendPlainForbiddenError: You can't send non-media (text) messages in this chat.
        `403`ChatSendStickersForbiddenError: You can't send stickers in this chat.
        `403`ChatSendVoicesForbiddenError: You can't send voice recordings in this chat.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `500`RandomIdDuplicateError: You provided a random ID that was already used.
        `500`SendMediaInvalidError: The specified media is invalid.
        `420`SlowmodeWaitError: Slowmode is enabled in this chat: wait {seconds} seconds before sending another message to this chat.

    """

    _id = 0XC0CF7646
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        query_id: int,
        id: str,
        silent: bool = False,
        background: bool = False,
        clear_draft: bool = False,
        hide_via: bool = False,
        reply_to: Optional['TypeInputReplyTo'] = None,
        schedule_date: Optional[int] = None,
        send_as: Optional['TypeInputPeer'] = None,
        quick_reply_shortcut: Optional['TypeInputQuickReplyShortcut'] = None,
        allow_paid_stars: Optional[int] = None,
        random_id: int = None
    ):

        """
        Send a result obtained using [messages.getInlineBotResults](https://core.telegram.org/method/messages.getInlineBotResults).

        Args:
            peer ('TypeInputPeer'): Destination
            query_id (int): Query ID from [messages.getInlineBotResults](https://core.telegram.org/method/messages.getInlineBotResults)
            id (str): Result ID from [messages.getInlineBotResults](https://core.telegram.org/method/messages.getInlineBotResults)
            silent (bool, optional): Whether to send the message silently (no notification will be triggered on the other client)
            background (bool, optional): Whether to send the message in background
            clear_draft (bool, optional): Whether to clear the [draft](https://core.telegram.org/api/drafts)
            hide_via (bool, optional): Whether to hide the via @botname in the resulting message (only for bot usernames encountered in the [config](https://core.telegram.org/constructor/config))
            reply_to (Optional['TypeInputReplyTo'], optional): If set, indicates that the message should be sent in reply to the specified message or story.
            schedule_date (Optional[int], optional): Scheduled message date for scheduled messages
            send_as (Optional['TypeInputPeer'], optional): Send this message as the specified peer
            quick_reply_shortcut (Optional['TypeInputQuickReplyShortcut'], optional): Add the message to the specified [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts), instead.
            allow_paid_stars (Optional[int], optional): ...
            random_id (int, optional): Random ID to avoid resending the same query
        """

        self.peer = peer
        self.query_id = query_id
        self.id = id
        self.silent = silent
        self.background = background
        self.clear_draft = clear_draft
        self.hide_via = hide_via
        self.reply_to = reply_to
        self.schedule_date = schedule_date
        self.send_as = send_as
        self.quick_reply_shortcut = quick_reply_shortcut
        self.allow_paid_stars = allow_paid_stars
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Fv\xcf\xc0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.silent, 5)
                flags(self.background, 6)
                flags(self.clear_draft, 7)
                flags(self.hide_via, 11)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.reply_to, 0):
                    writer.object(
                        self.reply_to,
                        group_id=0X8EEA0D0F
                    )
                writer.long(self.random_id)
                writer.long(self.query_id)
                writer.string(self.id)

                if flags(self.schedule_date, 10):
                    writer.int(self.schedule_date)

                if flags(self.send_as, 13):
                    writer.object(
                        self.send_as,
                        group_id=0X995DB9DF
                    )

                if flags(self.quick_reply_shortcut, 17):
                    writer.object(
                        self.quick_reply_shortcut,
                        group_id=0X60706B98
                    )

                if flags(self.allow_paid_stars, 21):
                    writer.long(self.allow_paid_stars)

            return writer.getvalue()