
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_reply_to import TypeInputReplyTo
    from ...types.input_single_media import TypeInputSingleMedia
    from ...types.input_quick_reply_shortcut import TypeInputQuickReplyShortcut


class SendMultiMedia(TLRequest[TypeUpdates]):
    """
    Send an [album or grouped media](https://core.telegram.org/api/files#albums-grouped-media)

    **Bots can use this method**

    Raises:
        `400`BusinessPeerInvalidError: Messages can't be set to the specified peer through the current [business connection](https://core.telegram.org/api/business#connected-bots).
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatForwardsRestrictedError: You can't forward messages from a protected chat.
        `400`EntityBoundsInvalidError: A specified [entity offset or length](https://core.telegram.org/api/entities#entity-length) is invalid, see [here &raquo;](https://core.telegram.org/api/entities#entity-length) for info on how to properly compute the entity offset/length.
        `400`FileReferenceExpiredError: File reference expired, it must be refetched as described in [the documentation](https://core.telegram.org/api/file_reference).
        `400`FileReferenceInvalidError: The specified [file reference](https://core.telegram.org/api/file_reference) is invalid.
        `400`MediaCaptionTooLongError: The caption is too long.
        `400`MediaEmptyError: The provided media object is invalid.
        `400`MediaInvalidError: Media invalid.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`MultiMediaTooLongError: Too many media files for album.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`QuickRepliesTooMuchError: A maximum of [appConfig.`quick_replies_limit`](https://core.telegram.org/api/config#quick-replies-limit) shortcuts may be created, the limit was reached.
        `400`RandomIdEmptyError: Random ID empty.
        `400`ReplyMessagesTooMuchError: Each shortcut can contain a maximum of [appConfig.`quick_reply_messages_limit`](https://core.telegram.org/api/config#quick-reply-messages-limit) messages, the limit was reached.
        `400`ReplyToInvalidError: The specified `reply_to` field is invalid.
        `400`ScheduleDateTooLateError: You can't schedule a message this far in the future.
        `400`ScheduleTooMuchError: There are too many scheduled messages.
        `400`SendAsPeerInvalidError: You can't send messages as the specified peer.
        `400`TopicClosedError: This topic was closed, you can't send messages to it anymore.
        `400`TopicDeletedError: The specified topic was deleted.
        `400`UserBannedInChannelError: You're banned from sending messages in supergroups/channels.
        `403`ChatSendMediaForbiddenError: You can't send media in this chat.
        `403`ChatSendPhotosForbiddenError: You can't send photos in this chat.
        `403`ChatSendVideosForbiddenError: You can't send videos in this chat.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `500`RandomIdDuplicateError: You provided a random ID that was already used.
        `420`SlowmodeWaitError: Slowmode is enabled in this chat: wait {seconds} seconds before sending another message to this chat.

    """

    _id = 0X1BF89D74
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        multi_media: List['TypeInputSingleMedia'],
        silent: bool = False,
        background: bool = False,
        clear_draft: bool = False,
        noforwards: bool = False,
        update_stickersets_order: bool = False,
        invert_media: bool = False,
        allow_paid_floodskip: bool = False,
        reply_to: Optional['TypeInputReplyTo'] = None,
        schedule_date: Optional[int] = None,
        send_as: Optional['TypeInputPeer'] = None,
        quick_reply_shortcut: Optional['TypeInputQuickReplyShortcut'] = None,
        effect: Optional[int] = None,
        allow_paid_stars: Optional[int] = None
    ):

        """
        Send an [album or grouped media](https://core.telegram.org/api/files#albums-grouped-media)

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): The destination chat
            multi_media (List['TypeInputSingleMedia']): The medias to send: note that they must be separately uploaded using [messages.uploadMedia](https://core.telegram.org/method/messages.uploadMedia) first, using raw inputMediaUploaded* constructors is not supported.
            silent (bool, optional): Whether to send the album silently (no notification triggered)
            background (bool, optional): Send in background?
            clear_draft (bool, optional): Whether to clear [drafts](https://core.telegram.org/api/drafts)
            noforwards (bool, optional): Only for bots, disallows forwarding and saving of the messages, even if the destination chat doesn't have [content protection](https://telegram.org/blog/protected-content-delete-by-date-and-more) enabled
            update_stickersets_order (bool, optional): Whether to move used stickersets to top, [see here for more info on this flag](https://core.telegram.org/api/stickers#recent-stickersets)
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            allow_paid_floodskip (bool, optional): Bots only: if set, allows sending up to 1000 messages per second, ignoring [broadcasting limits](https://core.telegram.org/bots/faq#how-can-i-message-all-of-my-bot-39s-subscribers-at-once) for a fee of 0.1 Telegram Stars per message. The relevant Stars will be withdrawn from the bot's balance.
            reply_to (Optional['TypeInputReplyTo'], optional): If set, indicates that the message should be sent in reply to the specified message or story.
            schedule_date (Optional[int], optional): Scheduled message date for scheduled messages
            send_as (Optional['TypeInputPeer'], optional): Send this message as the specified peer
            quick_reply_shortcut (Optional['TypeInputQuickReplyShortcut'], optional): Add the message to the specified [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts), instead.
            effect (Optional[int], optional): Specifies a [message effect](https://core.telegram.org/api/effects) to use for the message.
            allow_paid_stars (Optional[int], optional): ...
        """

        self.peer = peer
        self.multi_media = multi_media
        self.silent = silent
        self.background = background
        self.clear_draft = clear_draft
        self.noforwards = noforwards
        self.update_stickersets_order = update_stickersets_order
        self.invert_media = invert_media
        self.allow_paid_floodskip = allow_paid_floodskip
        self.reply_to = reply_to
        self.schedule_date = schedule_date
        self.send_as = send_as
        self.quick_reply_shortcut = quick_reply_shortcut
        self.effect = effect
        self.allow_paid_stars = allow_paid_stars

    def to_bytes(self, boxed: bool=True):
        with Writer(b't\x9d\xf8\x1b' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.silent, 5)
                flags(self.background, 6)
                flags(self.clear_draft, 7)
                flags(self.noforwards, 14)
                flags(self.update_stickersets_order, 15)
                flags(self.invert_media, 16)
                flags(self.allow_paid_floodskip, 19)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.reply_to, 0):
                    writer.object(
                        self.reply_to,
                        group_id=0X8EEA0D0F
                    )
                writer.vector(
                    self.multi_media,
                    lambda value: writer.object(
                        value,
                        group_id=0XB1D9AD4B
                    )
                )

                if flags(self.schedule_date, 10):
                    writer.int(self.schedule_date)

                if flags(self.send_as, 13):
                    writer.object(
                        self.send_as,
                        group_id=0X995DB9DF
                    )

                if flags(self.quick_reply_shortcut, 17):
                    writer.object(
                        self.quick_reply_shortcut,
                        group_id=0X60706B98
                    )

                if flags(self.effect, 18):
                    writer.long(self.effect)

                if flags(self.allow_paid_stars, 21):
                    writer.long(self.allow_paid_stars)

            return writer.getvalue()