
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Long, Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_reply_to import TypeInputReplyTo


class SendScreenshotNotification(TLRequest[TypeUpdates]):
    """
    Notify the other user in a private chat that a screenshot of the chat was taken

    Raises:
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`ReplyMessageIdInvalidError: The specified reply-to message ID is invalid.
        `400`StoryIdInvalidError: The specified story ID is invalid.
        `400`YouBlockedUserError: You blocked this user.

    """

    _id = 0XA1405817
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        reply_to: 'TypeInputReplyTo',
        random_id: int = None
    ):

        """
        Notify the other user in a private chat that a screenshot of the chat was taken

        Args:
            peer ('TypeInputPeer'): Other user
            reply_to ('TypeInputReplyTo'): Indicates the message that was screenshotted (the specified message ID can also be 0 to avoid indicating any specific message).
            random_id (int, optional): Random ID to avoid message resending
        """

        self.peer = peer
        self.reply_to = reply_to
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x17X@\xa1' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.object(
                self.reply_to,
                group_id=0X8EEA0D0F
            )
            writer.long(self.random_id)

            return writer.getvalue()