
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.send_message_action import TypeSendMessageAction


class SetTyping(TLRequest[bool]):
    """
    Sends a current user typing event (see [SendMessageAction](https://core.telegram.org/type/SendMessageAction) for all event types) to a conversation partner or group.

    **Bots can use this method**

    Raises:
        `400`BusinessPeerInvalidError: Messages can't be set to the specified peer through the current [business connection](https://core.telegram.org/api/business#connected-bots).
        `400`BusinessPeerUsageMissingError: You cannot send a message to a user through a [business connection](https://core.telegram.org/api/business#connected-bots) if the user hasn't recently contacted us.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`UserBannedInChannelError: You're banned from sending messages in supergroups/channels.
        `400`UserIsBotError: Bots can't send messages to other bots.
        `406`ChannelPrivateError: You haven't joined this channel/supergroup.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `403`GroupcallForbiddenError: The group call has already ended.
        `403`UserIsBlockedError: You were blocked by this user.

    """

    _id = 0X58943EE2
    _result_id = 0X43B904E1

    def __init__(
        self,
        peer: 'TypeInputPeer',
        action: 'TypeSendMessageAction',
        top_msg_id: Optional[int] = None
    ):

        """
        Sends a current user typing event (see [SendMessageAction](https://core.telegram.org/type/SendMessageAction) for all event types) to a conversation partner or group.

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): Target user or group
            action ('TypeSendMessageAction'): Type of action
            top_msg_id (Optional[int], optional): [Topic ID](https://core.telegram.org/api/threads)
        """

        self.peer = peer
        self.action = action
        self.top_msg_id = top_msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe2>\x94X' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.top_msg_id, 0):
                    writer.int(self.top_msg_id)
                writer.object(
                    self.action,
                    group_id=0X49241DFC
                )

            return writer.getvalue()