
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.affected_history import TypeMessagesAffectedHistory


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class UnpinAllMessages(TLRequest[TypeMessagesAffectedHistory]):
    """
    [Unpin](https://core.telegram.org/api/pin) all pinned messages

    **Bots can use this method**

    Raises:
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatNotModifiedError: No changes were made to chat information because the new information you passed is identical to the current information.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X62DD747
    _result_id = 0XC038BDBA

    def __init__(
        self,
        peer: 'TypeInputPeer',
        top_msg_id: Optional[int] = None,
        saved_peer_id: Optional['TypeInputPeer'] = None
    ):

        """
        [Unpin](https://core.telegram.org/api/pin) all pinned messages

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): Chat where to unpin
            top_msg_id (Optional[int], optional): [Forum topic](https://core.telegram.org/api/forum#forum-topics) where to unpin
            saved_peer_id (Optional['TypeInputPeer'], optional): ...
        """

        self.peer = peer
        self.top_msg_id = top_msg_id
        self.saved_peer_id = saved_peer_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'G\xd7-\x06' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.top_msg_id, 0):
                    writer.int(self.top_msg_id)

                if flags(self.saved_peer_id, 1):
                    writer.object(
                        self.saved_peer_id,
                        group_id=0X995DB9DF
                    )

            return writer.getvalue()