
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.message_media import TypeMessageMedia


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_media import TypeInputMedia


class UploadMedia(TLRequest[TypeMessageMedia]):
    """
    Upload a file and associate it to a chat (without actually sending it to the chat)

    **Bots can use this method**

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`ChatRestrictedError: You can't send messages in this chat, you were restricted.
        `400`FilePartsInvalidError: The number of file parts is invalid.
        `400`FilePartLengthInvalidError: The length of a file part is invalid.
        `400`ImageProcessFailedError: Failure while processing image.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MediaInvalidError: Media invalid.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`PhotoExtInvalidError: The extension of the photo is invalid.
        `400`PhotoInvalidDimensionsError: The photo dimensions are invalid.
        `400`PhotoSaveFileInvalidError: Internal issues, try again later.
        `400`UserBannedInChannelError: You're banned from sending messages in supergroups/channels.
        `400`VoiceMessagesForbiddenError: This user's privacy settings forbid you from sending voice messages.
        `400`WebpageCurlFailedError: Failure while fetching the webpage with cURL.
        `403`ChatWriteForbiddenError: You can't write in this chat.

    """

    _id = 0X14967978
    _result_id = 0X45F7A020

    def __init__(
        self,
        peer: 'TypeInputPeer',
        media: 'TypeInputMedia',
        business_connection_id: Optional[str] = None
    ):

        """
        Upload a file and associate it to a chat (without actually sending it to the chat)

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): The chat, can be [inputPeerEmpty](https://core.telegram.org/constructor/inputPeerEmpty) for bots and [inputPeerSelf](https://core.telegram.org/constructor/inputPeerSelf) for users.
            media ('TypeInputMedia'): File uploaded in chunks as described in [files](https://core.telegram.org/api/files)
            business_connection_id (Optional[str], optional): Whether the media will be used only in the specified [business connection](https://core.telegram.org/api/business#connected-bots), and not directly by the bot.
        """

        self.peer = peer
        self.media = media
        self.business_connection_id = business_connection_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'xy\x96\x14' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.business_connection_id, 0):
                    writer.string(self.business_connection_id)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.object(
                    self.media,
                    group_id=0XCEC6DE21
                )

            return writer.getvalue()