
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.phone.phone_call import TypePhonePhoneCall


if TYPE_CHECKING:
    from ...types.input_phone_call import TypeInputPhoneCall
    from ...types.phone_call_protocol import TypePhoneCallProtocol


class AcceptCall(TLRequest[TypePhonePhoneCall]):
    """
    Accept incoming call

    Raises:
        `400`CallAlreadyAcceptedError: The call was already accepted.
        `400`CallAlreadyDeclinedError: The call was already declined.
        `400`CallPeerInvalidError: The provided call peer object is invalid.
        `400`CallProtocolFlagsInvalidError: Call protocol flags invalid.
        `500`CallOccupyFailedError: The call failed because the user is already making another call.
        `406`CallProtocolCompatLayerInvalidError: The other side of the call does not support any of the VoIP protocols supported by the local client, as specified by the `protocol.layer` and `protocol.library_versions` fields.

    """

    _id = 0X3BD2B4A0
    _result_id = 0X6D677A4E

    def __init__(
        self,
        peer: 'TypeInputPhoneCall',
        g_b: bytes,
        protocol: 'TypePhoneCallProtocol'
    ):

        """
        Accept incoming call

        Args:
            peer ('TypeInputPhoneCall'): The call to accept
            g_b (bytes): [Parameter for E2E encryption key exchange](https://core.telegram.org/api/end-to-end/voice-calls)
            protocol ('TypePhoneCallProtocol'): Phone call settings
        """

        self.peer = peer
        self.g_b = g_b
        self.protocol = protocol

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa0\xb4\xd2;' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X3E51BD6B
            )
            writer.bytes(self.g_b)
            writer.object(
                self.protocol,
                group_id=0X11AF407E
            )

            return writer.getvalue()