
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_group_call import TypeInputGroupCall


class ToggleGroupCallRecord(TLRequest[TypeUpdates]):
    """
    Start or stop recording a group call: the recorded audio and video streams will be automatically sent to Saved messages (the chat with ourselves).

    Raises:
        `403`GroupcallForbiddenError: The group call has already ended.
        `400`GroupcallInvalidError: The specified group call is invalid.
        `400`GroupcallNotModifiedError: Group call settings weren't modified.

    """

    _id = 0XF128C708
    _result_id = 0XD68D29C0

    def __init__(
        self,
        call: 'TypeInputGroupCall',
        start: bool = False,
        video: bool = False,
        title: Optional[str] = None,
        video_portrait: bool = False
    ):

        """
        Start or stop recording a group call: the recorded audio and video streams will be automatically sent to Saved messages (the chat with ourselves).

        Args:
            call ('TypeInputGroupCall'): The group call or livestream
            start (bool, optional): Whether to start or stop recording
            video (bool, optional): Whether to also record video streams
            title (Optional[str], optional): Recording title
            video_portrait (bool, optional): If video stream recording is enabled, whether to record in portrait or landscape mode
        """

        self.call = call
        self.start = start
        self.video = video
        self.title = title
        self.video_portrait = video_portrait

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x08\xc7(\xf1' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.start, 0)
                flags(self.video, 2)
                writer.object(
                    self.call,
                    group_id=0XDA9A559A
                )

                if flags(self.title, 1):
                    writer.string(self.title)

                if flags(self.video_portrait, 2):
                    writer.object(
                        self.video_portrait,
                        group_id=0X43B904E1
                    )

            return writer.getvalue()