
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ...types.photos.photo import TypePhotosPhoto
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.input_file import TypeInputFile
    from ...types.video_size import TypeVideoSize


class UploadContactProfilePhoto(TLRequest[TypePhotosPhoto]):
    """
    Upload a custom profile picture for a contact, or suggest a new profile picture to a contact.

    Raises:
        `400`ContactMissingError: The specified user is not a contact.
        `400`UserIdInvalidError: The provided user ID is invalid.

    """

    _id = 0XE14C4A71
    _result_id = 0X6F58FEF2

    def __init__(
        self,
        user_id: 'TypeInputUser',
        suggest: bool = False,
        save: bool = False,
        file: Optional['TypeInputFile'] = None,
        video: Optional['TypeInputFile'] = None,
        video_start_ts: Optional[float] = None,
        video_emoji_markup: Optional['TypeVideoSize'] = None
    ):

        """
        Upload a custom profile picture for a contact, or suggest a new profile picture to a contact.

        Args:
            user_id ('TypeInputUser'): The contact
            suggest (bool, optional): If set, will send a [messageActionSuggestProfilePhoto](https://core.telegram.org/constructor/messageActionSuggestProfilePhoto) service message to user_id, suggesting them to use the specified profile picture; otherwise, will set a personal profile picture for the user (only visible to the current user).
            save (bool, optional): If set, removes a previously set personal profile picture (does not affect suggested profile pictures, to remove them simply deleted the [messageActionSuggestProfilePhoto](https://core.telegram.org/constructor/messageActionSuggestProfilePhoto) service message with [messages.deleteMessages](https://core.telegram.org/method/messages.deleteMessages)).
            file (Optional['TypeInputFile'], optional): Profile photo
            video (Optional['TypeInputFile'], optional): [Animated profile picture](https://core.telegram.org/api/files#animated-profile-pictures) video
            video_start_ts (Optional[float], optional): Floating point UNIX timestamp in seconds, indicating the frame of the video/sticker that should be used as static preview; can only be used if video or video_emoji_markup is set.
            video_emoji_markup (Optional['TypeVideoSize'], optional): Animated sticker profile picture, must contain either a [videoSizeEmojiMarkup](https://core.telegram.org/constructor/videoSizeEmojiMarkup) or a [videoSizeStickerMarkup](https://core.telegram.org/constructor/videoSizeStickerMarkup) constructor.
        """

        self.user_id = user_id
        self.suggest = suggest
        self.save = save
        self.file = file
        self.video = video
        self.video_start_ts = video_start_ts
        self.video_emoji_markup = video_emoji_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'qJL\xe1' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.suggest, 3)
                flags(self.save, 4)
                writer.object(
                    self.user_id,
                    group_id=0XB628962F
                )

                if flags(self.file, 0):
                    writer.object(
                        self.file,
                        group_id=0XB7247676
                    )

                if flags(self.video, 1):
                    writer.object(
                        self.video,
                        group_id=0XB7247676
                    )

                if flags(self.video_start_ts, 2):
                    writer.double(self.video_start_ts)

                if flags(self.video_emoji_markup, 5):
                    writer.object(
                        self.video_emoji_markup,
                        group_id=0X32B0FC60
                    )

            return writer.getvalue()