
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.sticker_set import TypeMessagesStickerSet


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.input_document import TypeInputDocument
    from ...types.input_sticker_set_item import TypeInputStickerSetItem


class CreateStickerSet(TLRequest[TypeMessagesStickerSet]):
    """
    Create a stickerset.

    **Bots can use this method**

    Raises:
        `400`PackShortNameInvalidError: Short pack name invalid.
        `400`PackShortNameOccupiedError: A stickerpack with this name already exists.
        `400`PackTitleInvalidError: The stickerpack title is invalid.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`StickersEmptyError: No sticker provided.
        `400`StickerEmojiInvalidError: Sticker emoji invalid.
        `400`StickerFileInvalidError: Sticker file invalid.
        `400`StickerGifDimensionsError: The specified video sticker has invalid dimensions.
        `400`StickerPngDimensionsError: Sticker png dimensions invalid.
        `400`StickerPngNopngError: One of the specified stickers is not a valid PNG file.
        `400`StickerTgsNodocError: You must send the animated sticker as a document.
        `400`StickerTgsNotgsError: Invalid TGS sticker provided.
        `400`StickerThumbPngNopngError: Incorrect stickerset thumb file provided, PNG / WEBP expected.
        `400`StickerThumbTgsNotgsError: Incorrect stickerset TGS thumb file provided.
        `400`StickerVideoBigError: The specified video sticker is too big.
        `400`StickerVideoNodocError: You must send the video sticker as a document.
        `400`StickerVideoNowebmError: The specified video sticker is not in webm format.
        `400`UserIdInvalidError: The provided user ID is invalid.

    """

    _id = 0X9021AB67
    _result_id = 0X5CC84E96

    def __init__(
        self,
        user_id: 'TypeInputUser',
        title: str,
        short_name: str,
        stickers: List['TypeInputStickerSetItem'],
        masks: bool = False,
        emojis: bool = False,
        text_color: bool = False,
        thumb: Optional['TypeInputDocument'] = None,
        software: Optional[str] = None
    ):

        """
        Create a stickerset.

        **Bots can use this method**

        Args:
            user_id ('TypeInputUser'): Stickerset owner
            title (str): Stickerset name, 1-64 chars
            short_name (str): Short name of sticker set, to be used in [sticker deep links](https://core.telegram.org/api/links#stickerset-links). Can contain only english letters, digits and underscores. Must begin with a letter, can't contain consecutive underscores and, if called by a bot, must end in "_by_<bot_username>". <bot_username> is case insensitive. 1-64 characters.
            stickers (List['TypeInputStickerSetItem']): Stickers
            masks (bool, optional): Whether this is a mask stickerset
            emojis (bool, optional): Whether this is a [custom emoji](https://core.telegram.org/api/custom-emoji) stickerset.
            text_color (bool, optional): Whether the color of TGS custom emojis contained in this set should be changed to the text color when used in messages, the accent color if used as emoji status, white on chat photos, or another appropriate color based on context. For custom emoji stickersets only.
            thumb (Optional['TypeInputDocument'], optional): Thumbnail
            software (Optional[str], optional): Used when [importing stickers using the sticker import SDKs](https://core.telegram.org/import-stickers), specifies the name of the software that created the stickers
        """

        self.user_id = user_id
        self.title = title
        self.short_name = short_name
        self.stickers = stickers
        self.masks = masks
        self.emojis = emojis
        self.text_color = text_color
        self.thumb = thumb
        self.software = software

    def to_bytes(self, boxed: bool=True):
        with Writer(b'g\xab!\x90' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.masks, 0)
                flags(self.emojis, 5)
                flags(self.text_color, 6)
                writer.object(
                    self.user_id,
                    group_id=0XB628962F
                )
                writer.string(self.title)
                writer.string(self.short_name)

                if flags(self.thumb, 2):
                    writer.object(
                        self.thumb,
                        group_id=0X84313E
                    )
                writer.vector(
                    self.stickers,
                    lambda value: writer.object(
                        value,
                        group_id=0X6B1BC0F3
                    )
                )

                if flags(self.software, 3):
                    writer.string(self.software)

            return writer.getvalue()