
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.stories.found_stories import TypeStoriesFoundStories


if TYPE_CHECKING:
    from ...types.media_area import TypeMediaArea
    from ...types.input_peer import TypeInputPeer


class SearchPosts(TLRequest[TypeStoriesFoundStories]):
    """
    Globally search for [stories](https://core.telegram.org/api/stories) using a hashtag or a [location media area](https://core.telegram.org/api/stories#location-tags), see [here](https://core.telegram.org/api/stories#searching-stories) for more info on the full flow.

    Raises:
        `400`HashtagInvalidError: The specified hashtag is invalid.

    """

    _id = 0XD1810907
    _result_id = 0XF4730BF7

    def __init__(
        self,
        offset: str,
        limit: int,
        hashtag: Optional[str] = None,
        area: Optional['TypeMediaArea'] = None,
        peer: Optional['TypeInputPeer'] = None
    ):

        """
        Globally search for [stories](https://core.telegram.org/api/stories) using a hashtag or a [location media area](https://core.telegram.org/api/stories#location-tags), see [here](https://core.telegram.org/api/stories#searching-stories) for more info on the full flow.

        Args:
            offset (str): Offset for [pagination](https://core.telegram.org/api/offsets): initially an empty string, then the next_offset from the previously returned [stories.foundStories](https://core.telegram.org/constructor/stories.foundStories).
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            hashtag (Optional[str], optional): Hashtag (without the #)
            area (Optional['TypeMediaArea'], optional): A [mediaAreaGeoPoint](https://core.telegram.org/constructor/mediaAreaGeoPoint) or a [mediaAreaVenue](https://core.telegram.org/constructor/mediaAreaVenue).  Note [mediaAreaGeoPoint](https://core.telegram.org/constructor/mediaAreaGeoPoint) areas may be searched only if they have an associated address.
            peer (Optional['TypeInputPeer'], optional): If set, returns only stories posted by this peer.
        """

        self.offset = offset
        self.limit = limit
        self.hashtag = hashtag
        self.area = area
        self.peer = peer

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x07\t\x81\xd1' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.hashtag, 0):
                    writer.string(self.hashtag)

                if flags(self.area, 1):
                    writer.object(
                        self.area,
                        group_id=0XA32C529B
                    )

                if flags(self.peer, 2):
                    writer.object(
                        self.peer,
                        group_id=0X995DB9DF
                    )
                writer.string(self.offset)
                writer.int(self.limit)

            return writer.getvalue()