
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..chat_theme import TypeChatTheme
    from ....gadgets.byteutils import Reader


class ChatThemesNotModified(TLObject, family='TypeAccountChatThemes'):
    """
    The available chat themes were not modified
    """

    _id = 0XE011E1C4
    _group_id = 0XFE25AF5E


    def to_bytes(self, boxed: bool=True):
        return b'\xc4\xe1\x11\xe0' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class ChatThemes(TLObject, family='TypeAccountChatThemes'):
    """
    Available chat themes
    """

    _id = 0X16484857
    _group_id = 0XFE25AF5E

    def __init__(
        self,
        hash: int,
        themes: List['TypeChatTheme'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        next_offset: Optional[int] = None
    ):

        """
        Available chat themes

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            themes (List['TypeChatTheme']): Available chat themes
            chats (List['TypeChat']): ...
            users (List['TypeUser']): ...
            next_offset (Optional[int], optional): ...
        """

        self.hash = hash
        self.themes = themes
        self.chats = chats
        self.users = users
        self.next_offset = next_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'WHH\x16' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.hash)
                writer.vector(
                    self.themes,
                    lambda value: writer.object(
                        value,
                        group_id=0X7FBD8E9C
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

                if flags(self.next_offset, 0):
                    writer.int(self.next_offset)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        hash_ = reader.long()
        themes_ = reader.vector(
            lambda: reader.object(
                group_id=0X7FBD8E9C
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        next_offset_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            hash=hash_,
            themes=themes_,
            chats=chats_,
            users=users_,
            next_offset=next_offset_
        )

TypeAccountChatThemes = Union[
    ChatThemesNotModified,
    ChatThemes
]