
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..password_kdf_algo import TypePasswordKdfAlgo
    from ....gadgets.byteutils import Reader
    from ..secure_password_kdf_algo import TypeSecurePasswordKdfAlgo


class Password(TLObject, family='TypeAccountPassword'):
    """
    Configuration for two-factor authorization
    """

    _id = 0X957B50FB
    _group_id = 0X552CED27

    def __init__(
        self,
        new_algo: 'TypePasswordKdfAlgo',
        new_secure_algo: 'TypeSecurePasswordKdfAlgo',
        secure_random: bytes,
        has_recovery: bool = False,
        has_secure_values: bool = False,
        has_password: bool = False,
        current_algo: Optional['TypePasswordKdfAlgo'] = None,
        srp_B: Optional[bytes] = None,
        srp_id: Optional[int] = None,
        hint: Optional[str] = None,
        email_unconfirmed_pattern: Optional[str] = None,
        pending_reset_date: Optional[int] = None,
        login_email_pattern: Optional[str] = None
    ):

        """
        Configuration for two-factor authorization

        Args:
            new_algo ('TypePasswordKdfAlgo'): The [KDF algorithm for SRP two-factor authentication](https://core.telegram.org/api/srp) to use when creating new passwords
            new_secure_algo ('TypeSecurePasswordKdfAlgo'): The KDF algorithm for telegram [passport](https://core.telegram.org/passport)
            secure_random (bytes): Secure random string
            has_recovery (bool, optional): Whether the user has a recovery method configured
            has_secure_values (bool, optional): Whether telegram [passport](https://core.telegram.org/passport) is enabled
            has_password (bool, optional): Whether the user has a password
            current_algo (Optional['TypePasswordKdfAlgo'], optional): The [KDF algorithm for SRP two-factor authentication](https://core.telegram.org/api/srp) of the current password
            srp_B (Optional[bytes], optional): Srp B param for [SRP authorization](https://core.telegram.org/api/srp)
            srp_id (Optional[int], optional): Srp ID param for [SRP authorization](https://core.telegram.org/api/srp)
            hint (Optional[str], optional): Text hint for the password
            email_unconfirmed_pattern (Optional[str], optional): A [password recovery email](https://core.telegram.org/api/srp#email-verification) with the specified [pattern](https://core.telegram.org/api/pattern) is still awaiting verification
            pending_reset_date (Optional[int], optional): The 2FA password will be automatically removed at this date, unless the user cancels the operation
            login_email_pattern (Optional[str], optional): A verified login email with the specified [pattern](https://core.telegram.org/api/pattern) is configured
        """

        self.new_algo = new_algo
        self.new_secure_algo = new_secure_algo
        self.secure_random = secure_random
        self.has_recovery = has_recovery
        self.has_secure_values = has_secure_values
        self.has_password = has_password
        self.current_algo = current_algo
        self.srp_B = srp_B
        self.srp_id = srp_id
        self.hint = hint
        self.email_unconfirmed_pattern = email_unconfirmed_pattern
        self.pending_reset_date = pending_reset_date
        self.login_email_pattern = login_email_pattern

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfbP{\x95' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.has_recovery, 0)
                flags(self.has_secure_values, 1)
                flags(self.has_password, 2)

                if flags(self.current_algo, 2):
                    writer.object(
                        self.current_algo,
                        group_id=0X9B82F7C3
                    )

                if flags(self.srp_B, 2):
                    writer.bytes(self.srp_B)

                if flags(self.srp_id, 2):
                    writer.long(self.srp_id)

                if flags(self.hint, 3):
                    writer.string(self.hint)

                if flags(self.email_unconfirmed_pattern, 4):
                    writer.string(self.email_unconfirmed_pattern)
                writer.object(
                    self.new_algo,
                    group_id=0X9B82F7C3
                )
                writer.object(
                    self.new_secure_algo,
                    group_id=0X3C26E360
                )
                writer.bytes(self.secure_random)

                if flags(self.pending_reset_date, 5):
                    writer.int(self.pending_reset_date)

                if flags(self.login_email_pattern, 6):
                    writer.string(self.login_email_pattern)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        current_algo_ = (
            reader.object(
                group_id=0X9B82F7C3
            )
            if flags(2) else None
        )

        srp_B_ = (
            reader.bytes()
            if flags(2) else None
        )

        srp_id_ = (
            reader.long()
            if flags(2) else None
        )

        hint_ = (
            reader.string()
            if flags(3) else None
        )

        email_unconfirmed_pattern_ = (
            reader.string()
            if flags(4) else None
        )

        new_algo_ = reader.object(
            group_id=0X9B82F7C3
        )

        new_secure_algo_ = reader.object(
            group_id=0X3C26E360
        )

        secure_random_ = reader.bytes()
        pending_reset_date_ = (
            reader.int()
            if flags(5) else None
        )

        login_email_pattern_ = (
            reader.string()
            if flags(6) else None
        )

        return cls(
            new_algo=new_algo_,
            new_secure_algo=new_secure_algo_,
            secure_random=secure_random_,
            has_recovery=flags(0),
            has_secure_values=flags(1),
            has_password=flags(2),
            current_algo=current_algo_,
            srp_B=srp_B_,
            srp_id=srp_id_,
            hint=hint_,
            email_unconfirmed_pattern=email_unconfirmed_pattern_,
            pending_reset_date=pending_reset_date_,
            login_email_pattern=login_email_pattern_
        )

TypeAccountPassword = Password