
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..password_kdf_algo import TypePasswordKdfAlgo
    from ....gadgets.byteutils import Reader
    from ..secure_secret_settings import TypeSecureSecretSettings


class PasswordInputSettings(TLObject, family='TypeAccountPasswordInputSettings'):
    """
    Settings for setting up a new password
    """

    _id = 0XC23727C9
    _group_id = 0X59FEE6C

    def __init__(
        self,
        new_algo: Optional['TypePasswordKdfAlgo'] = None,
        new_password_hash: Optional[bytes] = None,
        hint: Optional[str] = None,
        email: Optional[str] = None,
        new_secure_settings: Optional['TypeSecureSecretSettings'] = None
    ):

        """
        Settings for setting up a new password

        Args:
            new_algo (Optional['TypePasswordKdfAlgo'], optional): The [SRP algorithm](https://core.telegram.org/api/srp) to use
            new_password_hash (Optional[bytes], optional): The [computed password hash](https://core.telegram.org/api/srp)
            hint (Optional[str], optional): Text hint for the password
            email (Optional[str], optional): Password recovery email
            new_secure_settings (Optional['TypeSecureSecretSettings'], optional): Telegram [passport](https://core.telegram.org/passport) settings
        """

        self.new_algo = new_algo
        self.new_password_hash = new_password_hash
        self.hint = hint
        self.email = email
        self.new_secure_settings = new_secure_settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b"\xc9'7\xc2" if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.new_algo, 0):
                    writer.object(
                        self.new_algo,
                        group_id=0X9B82F7C3
                    )

                if flags(self.new_password_hash, 0):
                    writer.bytes(self.new_password_hash)

                if flags(self.hint, 0):
                    writer.string(self.hint)

                if flags(self.email, 1):
                    writer.string(self.email)

                if flags(self.new_secure_settings, 2):
                    writer.object(
                        self.new_secure_settings,
                        group_id=0XC2D666DE
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        new_algo_ = (
            reader.object(
                group_id=0X9B82F7C3
            )
            if flags(0) else None
        )

        new_password_hash_ = (
            reader.bytes()
            if flags(0) else None
        )

        hint_ = (
            reader.string()
            if flags(0) else None
        )

        email_ = (
            reader.string()
            if flags(1) else None
        )

        new_secure_settings_ = (
            reader.object(
                group_id=0XC2D666DE
            )
            if flags(2) else None
        )

        return cls(
            new_algo=new_algo_,
            new_password_hash=new_password_hash_,
            hint=hint_,
            email=email_,
            new_secure_settings=new_secure_settings_
        )

TypeAccountPasswordInputSettings = PasswordInputSettings