
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .authorization import TypeAuthAuthorization
    from ....gadgets.byteutils import Reader


class LoginToken(TLObject, family='TypeAuthLoginToken'):
    """
    Login token (for [QR code login](https://core.telegram.org/api/qr-login))
    """

    _id = 0X629F1980
    _group_id = 0X4C003CCD

    def __init__(
        self,
        expires: int,
        token: bytes
    ):

        """
        Login token (for [QR code login](https://core.telegram.org/api/qr-login))

        Args:
            expires (int): Expiration date of QR code
            token (bytes): Token to render in QR code
        """

        self.expires = expires
        self.token = token

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x80\x19\x9fb' if boxed else b'') as writer:
            writer.int(self.expires)
            writer.bytes(self.token)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        expires_ = reader.int()
        token_ = reader.bytes()

        return cls(
            expires=expires_,
            token=token_
        )

class LoginTokenMigrateTo(TLObject, family='TypeAuthLoginToken'):
    """
    Repeat the query to the specified DC
    """

    _id = 0X68E9916
    _group_id = 0X4C003CCD

    def __init__(
        self,
        dc_id: int,
        token: bytes
    ):

        """
        Repeat the query to the specified DC

        Args:
            dc_id (int): DC ID
            token (bytes): Token to use for login
        """

        self.dc_id = dc_id
        self.token = token

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x16\x99\x8e\x06' if boxed else b'') as writer:
            writer.int(self.dc_id)
            writer.bytes(self.token)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        dc_id_ = reader.int()
        token_ = reader.bytes()

        return cls(
            dc_id=dc_id_,
            token=token_
        )

class LoginTokenSuccess(TLObject, family='TypeAuthLoginToken'):
    """
    Login via token (QR code) succeeded!
    """

    _id = 0X390D5C5E
    _group_id = 0X4C003CCD

    def __init__(
        self,
        authorization: 'TypeAuthAuthorization'
    ):

        """
        Login via token (QR code) succeeded!

        Args:
            authorization ('TypeAuthAuthorization'): Authorization info
        """

        self.authorization = authorization

    def to_bytes(self, boxed: bool=True):
        with Writer(b'^\\\r9' if boxed else b'') as writer:
            writer.object(
                self.authorization,
                group_id=0X2A654890
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        authorization_ = reader.object(
            group_id=0X2A654890
        )

        return cls(
            authorization=authorization_
        )

TypeAuthLoginToken = Union[
    LoginToken,
    LoginTokenMigrateTo,
    LoginTokenSuccess
]