
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class Authorization(TLObject, family='TypeAuthorization'):
    """
    Logged-in session
    """

    _id = 0XAD01D61D
    _group_id = 0X3AA82A4C

    def __init__(
        self,
        hash: int,
        device_model: str,
        platform: str,
        system_version: str,
        api_id: int,
        app_name: str,
        app_version: str,
        date_created: int,
        date_active: int,
        ip: str,
        country: str,
        region: str,
        current: bool = False,
        official_app: bool = False,
        password_pending: bool = False,
        encrypted_requests_disabled: bool = False,
        call_requests_disabled: bool = False,
        unconfirmed: bool = False
    ):

        """
        Logged-in session

        Args:
            hash (int): Identifier
            device_model (str): Device model
            platform (str): Platform
            system_version (str): System version
            api_id (int): [API ID](https://core.telegram.org/api/obtaining_api_id)
            app_name (str): App name
            app_version (str): App version
            date_created (int): When was the session created
            date_active (int): When was the session last active
            ip (str): Last known IP
            country (str): Country determined from IP
            region (str): Region determined from IP
            current (bool, optional): Whether this is the current session
            official_app (bool, optional): Whether the session is from an official app
            password_pending (bool, optional): Whether the session is still waiting for a 2FA password
            encrypted_requests_disabled (bool, optional): Whether this session will accept encrypted chats
            call_requests_disabled (bool, optional): Whether this session will accept phone calls
            unconfirmed (bool, optional): Whether the session is [unconfirmed, see here](https://core.telegram.org/api/auth#confirming-login) for more info.
        """

        self.hash = hash
        self.device_model = device_model
        self.platform = platform
        self.system_version = system_version
        self.api_id = api_id
        self.app_name = app_name
        self.app_version = app_version
        self.date_created = date_created
        self.date_active = date_active
        self.ip = ip
        self.country = country
        self.region = region
        self.current = current
        self.official_app = official_app
        self.password_pending = password_pending
        self.encrypted_requests_disabled = encrypted_requests_disabled
        self.call_requests_disabled = call_requests_disabled
        self.unconfirmed = unconfirmed

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1d\xd6\x01\xad' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.current, 0)
                flags(self.official_app, 1)
                flags(self.password_pending, 2)
                flags(self.encrypted_requests_disabled, 3)
                flags(self.call_requests_disabled, 4)
                flags(self.unconfirmed, 5)
                writer.long(self.hash)
                writer.string(self.device_model)
                writer.string(self.platform)
                writer.string(self.system_version)
                writer.int(self.api_id)
                writer.string(self.app_name)
                writer.string(self.app_version)
                writer.int(self.date_created)
                writer.int(self.date_active)
                writer.string(self.ip)
                writer.string(self.country)
                writer.string(self.region)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        hash_ = reader.long()
        device_model_ = reader.string()
        platform_ = reader.string()
        system_version_ = reader.string()
        api_id_ = reader.int()
        app_name_ = reader.string()
        app_version_ = reader.string()
        date_created_ = reader.int()
        date_active_ = reader.int()
        ip_ = reader.string()
        country_ = reader.string()
        region_ = reader.string()

        return cls(
            hash=hash_,
            device_model=device_model_,
            platform=platform_,
            system_version=system_version_,
            api_id=api_id_,
            app_name=app_name_,
            app_version=app_version_,
            date_created=date_created_,
            date_active=date_active_,
            ip=ip_,
            country=country_,
            region=region_,
            current=flags(0),
            official_app=flags(1),
            password_pending=flags(2),
            encrypted_requests_disabled=flags(3),
            call_requests_disabled=flags(4),
            unconfirmed=flags(5)
        )

TypeAuthorization = Authorization