
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .business_bot_rights import TypeBusinessBotRights
    from ...gadgets.byteutils import Reader


class BotBusinessConnection(TLObject, family='TypeBotBusinessConnection'):
    """
    Contains info about a [bot business connection](https://core.telegram.org/api/business#connected-bots).
    """

    _id = 0X8F34B2F5
    _group_id = 0XD013CF65

    def __init__(
        self,
        connection_id: str,
        user_id: int,
        dc_id: int,
        date: int,
        disabled: bool = False,
        rights: Optional['TypeBusinessBotRights'] = None
    ):

        """
        Contains info about a [bot business connection](https://core.telegram.org/api/business#connected-bots).

        Args:
            connection_id (str): Business connection ID, used to identify messages coming from the connection and to reply to them as specified [here](https://core.telegram.org/api/business#connected-bots).
            user_id (int): ID of the user that the bot is connected to via this connection.
            dc_id (int): ID of the datacenter where to send queries wrapped in a [invokeWithBusinessConnection](https://core.telegram.org/method/invokeWithBusinessConnection) as specified [here](https://core.telegram.org/api/business#connected-bots).
            date (int): When was the connection created.
            disabled (bool, optional): Whether this business connection is currently disabled
            rights (Optional['TypeBusinessBotRights'], optional): ...
        """

        self.connection_id = connection_id
        self.user_id = user_id
        self.dc_id = dc_id
        self.date = date
        self.disabled = disabled
        self.rights = rights

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf5\xb24\x8f' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.disabled, 1)
                writer.string(self.connection_id)
                writer.long(self.user_id)
                writer.int(self.dc_id)
                writer.int(self.date)

                if flags(self.rights, 2):
                    writer.object(
                        self.rights,
                        group_id=0XD14AA447
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        connection_id_ = reader.string()
        user_id_ = reader.long()
        dc_id_ = reader.int()
        date_ = reader.int()
        rights_ = (
            reader.object(
                group_id=0XD14AA447
            )
            if flags(2) else None
        )

        return cls(
            connection_id=connection_id_,
            user_id=user_id_,
            dc_id=dc_id_,
            date=date_,
            disabled=flags(1),
            rights=rights_
        )

TypeBotBusinessConnection = BotBusinessConnection