
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .document import TypeDocument
    from ...gadgets.byteutils import Reader


class BusinessIntro(TLObject, family='TypeBusinessIntro'):
    """
    [Telegram Business introduction](https://core.telegram.org/api/business#business-introduction).
    """

    _id = 0X5A0A066D
    _group_id = 0X96BF3991

    def __init__(
        self,
        title: str,
        description: str,
        sticker: Optional['TypeDocument'] = None
    ):

        """
        [Telegram Business introduction](https://core.telegram.org/api/business#business-introduction).

        Args:
            title (str): Title of the introduction message (max [intro_title_length_limit](https://core.telegram.org/api/config#intro-title-length-limit) UTF-8 characters).
            description (str): Profile introduction (max [intro_description_length_limit](https://core.telegram.org/api/config#intro-description-length-limit) UTF-8 characters).
            sticker (Optional['TypeDocument'], optional): Optional introduction [sticker](https://core.telegram.org/api/stickers).
        """

        self.title = title
        self.description = description
        self.sticker = sticker

    def to_bytes(self, boxed: bool=True):
        with Writer(b'm\x06\nZ' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.title)
                writer.string(self.description)

                if flags(self.sticker, 0):
                    writer.object(
                        self.sticker,
                        group_id=0X6547BD50
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        title_ = reader.string()
        description_ = reader.string()
        sticker_ = (
            reader.object(
                group_id=0X6547BD50
            )
            if flags(0) else None
        )

        return cls(
            title=title_,
            description=description_,
            sticker=sticker_
        )

TypeBusinessIntro = BusinessIntro