
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class BusinessRecipients(TLObject, family='TypeBusinessRecipients'):
    """
    Specifies the chats that can receive Telegram Business [away](https://core.telegram.org/api/business#away-messages) and [greeting](https://core.telegram.org/api/business#greeting-messages) messages.
    """

    _id = 0X21108FF7
    _group_id = 0XAA8E16FE

    def __init__(
        self,
        existing_chats: bool = False,
        new_chats: bool = False,
        contacts: bool = False,
        non_contacts: bool = False,
        exclude_selected: bool = False,
        users: Optional[List[int]] = None
    ):

        """
        Specifies the chats that can receive Telegram Business [away](https://core.telegram.org/api/business#away-messages) and [greeting](https://core.telegram.org/api/business#greeting-messages) messages.

        Args:
            existing_chats (bool, optional): All existing private chats.
            new_chats (bool, optional): All new private chats.
            contacts (bool, optional): All private chats with contacts.
            non_contacts (bool, optional): All private chats with non-contacts.
            exclude_selected (bool, optional): If set, inverts the selection.
            users (Optional[List[int]], optional): Only private chats with the specified users.
        """

        self.existing_chats = existing_chats
        self.new_chats = new_chats
        self.contacts = contacts
        self.non_contacts = non_contacts
        self.exclude_selected = exclude_selected
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf7\x8f\x10!' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.existing_chats, 0)
                flags(self.new_chats, 1)
                flags(self.contacts, 2)
                flags(self.non_contacts, 3)
                flags(self.exclude_selected, 5)

                if flags(self.users, 4):
                    writer.vector(
                        self.users,
                        writer.long
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        users_ = (
            reader.vector(
                reader.long
            )
            if flags(4) else None
        )

        return cls(
            existing_chats=flags(0),
            new_chats=flags(1),
            contacts=flags(2),
            non_contacts=flags(3),
            exclude_selected=flags(5),
            users=users_
        )

TypeBusinessRecipients = BusinessRecipients