
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class BusinessWeeklyOpen(TLObject, family='TypeBusinessWeeklyOpen'):
    """
    A time interval, indicating the opening hours of a business.
    """

    _id = 0X120B1AB9
    _group_id = 0XE04B1E9F

    def __init__(
        self,
        start_minute: int,
        end_minute: int
    ):

        """
        A time interval, indicating the opening hours of a business.

        Args:
            start_minute (int): Start minute in minutes of the week, 0 to 7*24*60 inclusively.
            end_minute (int): End minute in minutes of the week, 1 to 8*24*60 inclusively ( 8 and not 7 because this allows to specify intervals that, for example, start on Sunday 21:00 and end on Monday 04:00 ( 6*24*60+21*60 to 7*24*60+4*60) without passing an invalid end_minute < start_minute). See [here](https://core.telegram.org/api/business#opening-hours) for more info.
        """

        self.start_minute = start_minute
        self.end_minute = end_minute

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb9\x1a\x0b\x12' if boxed else b'') as writer:
            writer.int(self.start_minute)
            writer.int(self.end_minute)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        start_minute_ = reader.int()
        end_minute_ = reader.int()

        return cls(
            start_minute=start_minute_,
            end_minute=end_minute_
        )

TypeBusinessWeeklyOpen = BusinessWeeklyOpen