
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class EmojiKeyword(TLObject, family='TypeEmojiKeyword'):
    """
    Emoji keyword
    """

    _id = 0XD5B3B9F9
    _group_id = 0X6489BB2C

    def __init__(
        self,
        keyword: str,
        emoticons: List[str]
    ):

        """
        Emoji keyword

        Args:
            keyword (str): Keyword
            emoticons (List[str]): Emojis associated to keyword
        """

        self.keyword = keyword
        self.emoticons = emoticons

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf9\xb9\xb3\xd5' if boxed else b'') as writer:
            writer.string(self.keyword)
            writer.vector(
                self.emoticons,
                writer.string
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        keyword_ = reader.string()
        emoticons_ = reader.vector(
            reader.string
        )

        return cls(
            keyword=keyword_,
            emoticons=emoticons_
        )

class EmojiKeywordDeleted(TLObject, family='TypeEmojiKeyword'):
    """
    Deleted emoji keyword
    """

    _id = 0X236DF622
    _group_id = 0X6489BB2C

    def __init__(
        self,
        keyword: str,
        emoticons: List[str]
    ):

        """
        Deleted emoji keyword

        Args:
            keyword (str): Keyword
            emoticons (List[str]): Emojis that were associated to keyword
        """

        self.keyword = keyword
        self.emoticons = emoticons

    def to_bytes(self, boxed: bool=True):
        with Writer(b'"\xf6m#' if boxed else b'') as writer:
            writer.string(self.keyword)
            writer.vector(
                self.emoticons,
                writer.string
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        keyword_ = reader.string()
        emoticons_ = reader.vector(
            reader.string
        )

        return cls(
            keyword=keyword_,
            emoticons=emoticons_
        )

TypeEmojiKeyword = Union[
    EmojiKeyword,
    EmojiKeywordDeleted
]