
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class GeoPointAddress(TLObject, family='TypeGeoPointAddress'):
    """
    Address optionally associated to a [geoPoint](https://core.telegram.org/constructor/geoPoint).
    """

    _id = 0XDE4C5D93
    _group_id = 0X3A6BC0D7

    def __init__(
        self,
        country_iso2: str,
        state: Optional[str] = None,
        city: Optional[str] = None,
        street: Optional[str] = None
    ):

        """
        Address optionally associated to a [geoPoint](https://core.telegram.org/constructor/geoPoint).

        Args:
            country_iso2 (str): Two-letter ISO 3166-1 alpha-2 country code
            state (Optional[str], optional): State
            city (Optional[str], optional): City
            street (Optional[str], optional): Street
        """

        self.country_iso2 = country_iso2
        self.state = state
        self.city = city
        self.street = street

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x93]L\xde' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.country_iso2)

                if flags(self.state, 0):
                    writer.string(self.state)

                if flags(self.city, 1):
                    writer.string(self.city)

                if flags(self.street, 2):
                    writer.string(self.street)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        country_iso2_ = reader.string()
        state_ = (
            reader.string()
            if flags(0) else None
        )

        city_ = (
            reader.string()
            if flags(1) else None
        )

        street_ = (
            reader.string()
            if flags(2) else None
        )

        return cls(
            country_iso2=country_iso2_,
            state=state_,
            city=city_,
            street=street_
        )

TypeGeoPointAddress = GeoPointAddress